package rozdzial6;

import java.io.*;
import java.security.*;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

/**
 * Prosty przykad uycia klasy CertificateFactory.
 */
public class CertificateFactoryExample
{
    public static void main(String[] args)
        throws Exception
    {
        // utworzenie kluczy
        KeyPair          pair = Utils.generateRSAKeyPair();
        
        // utworzenie strumienia wejciowego
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        
        bOut.write(X509V1CreateExample.generateV1Certificate(pair).getEncoded());
        
        bOut.close();
        
        InputStream in = new ByteArrayInputStream(bOut.toByteArray());
        
        // utworzenie instancji CertificateFactory
        CertificateFactory fact = CertificateFactory.getInstance("X.509","BC");
        
        // wczytanie certyfikatu
        X509Certificate    x509Cert = (X509Certificate)fact.generateCertificate(in);
        
        System.out.println("wystawca: " + x509Cert.getIssuerX500Principal());
    }
}
