package rozdzial6;

import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

/**
 * Prosty przykad tworzenia i kodowania obiektu CertPath.
 */
public class CertPathExample
{
   public static void main(
      String[] args)
       throws Exception
   {
        X509Certificate[]   chain = PKCS10CertCreateExample.buildChain();
      
        // utworzenie fabryki certyfikatw i obiektu cieki CertPath
        CertificateFactory  fact = CertificateFactory.getInstance("X.509", "BC");
        CertPath            certPath = fact.generateCertPath(Arrays.asList(chain));

        byte[] encoded = certPath.getEncoded("PEM");

        System.out.println(Utils.toString(encoded));
      
        // odtworzenie cieki certyfikatw
        CertPath           newCertPath = fact.generateCertPath(new ByteArrayInputStream(encoded), "PEM");

        if (newCertPath.equals(certPath))
        {
            System.out.println("cieka certyfikatw odtworzona poprawnie");
        }
    }
}
