package rozdzial5;

import java.security.AlgorithmParameters;
import java.security.Signature;
import java.security.spec.PSSParameterSpec;

import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.util.ASN1Dump;

/**
 * Przykad ilustrujcy pobieranie i kodowanie parametrw PSS.
 */
public class PSSParamExample
{

    public static void main(String[] args)
        throws Exception
    {
        Signature           signature = Signature.getInstance("SHA1withRSAandMGF1", "BC");

        // ustawienie parametrw domylnych
        signature.setParameter(PSSParameterSpec.DEFAULT);
        
        // pobranie parametrw domylnych
        AlgorithmParameters   params = signature.getParameters();
       
        // wypisanie kodu binarnego struktury ASN.1
        ASN1InputStream     aIn = new ASN1InputStream(params.getEncoded("ASN.1"));
        
        System.out.println(ASN1Dump.dumpAsString(aIn.readObject()));
    }
}
