package rozdzial4;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;


import javax.crypto.Cipher;

/**
 * Przykad RSA z losowym generowaniem klucza.
 */
public class RandomKeyRSAExample
{
    public static void main(
        String[]    args)
        throws Exception
    {
        byte[]           input = new byte[] { (byte)0xbe, (byte)0xef };
        Cipher          cipher = Cipher.getInstance("RSA/NONE/NoPadding", "BC");
        SecureRandom     random = Utils.createFixedRandom();
        
        // Generowanie kluczy
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        
        generator.initialize(256, random);

        KeyPair          pair = generator.generateKeyPair();
        Key              pubKey = pair.getPublic();
        Key              privKey = pair.getPrivate();

        System.out.println("dane wejciowe: " + Utils.toHex(input));
        
        // Szyfrowanie
        
        cipher.init(Cipher.ENCRYPT_MODE, pubKey, random);

        byte[] cipherText = cipher.doFinal(input);

        System.out.println("dane zaszyfrowane: " + Utils.toHex(cipherText));
        
        // Deszyfrowanie

        cipher.init(Cipher.DECRYPT_MODE, privKey);

        byte[] plainText = cipher.doFinal(cipherText);
        
        System.out.println("dane odszyfrowane: " + Utils.toHex(plainText));
    }
}
