package rozdzial3;

import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;

import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 * Modyfikacja wiadomoci z kodem HMAC, szyfrowanie AES w trybie CTR.
 */
public class TamperedWithHMacExample
{   
    public static void main(
        String[]    args)
        throws Exception
    {
        SecureRandom random = new SecureRandom();
        IvParameterSpec ivSpec = Utils.createCtrIvForAES(1, random);
        Key             key = Utils.createKeyForAES(256, random);
        Cipher          cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        String          input = "Przelew 0000100 na AC 1234-5678";
        Mac             hMac = Mac.getInstance("HMacSHA1", "BC");
        Key             hMacKey = new SecretKeySpec(key.getEncoded(), "HMacSHA1");
        
        System.out.println("dane wejciowe: " + input);
        
        // szyfrowanie
        
        cipher.init(Cipher.ENCRYPT_MODE, key, ivSpec);
        
        byte[] cipherText = new byte[cipher.getOutputSize(input.length() + hMac.getMacLength())];

        int ctLength = cipher.update(Utils.toByteArray(input), 0, input.length(), cipherText, 0);
        
        hMac.init(hMacKey);
        hMac.update(Utils.toByteArray(input));
        
        ctLength += cipher.doFinal(hMac.doFinal(), 0, hMac.getMacLength(), cipherText, ctLength);
        
        // modyfikacja
        
        cipherText[8] ^= '0' ^ '9';
        
        // podmiana skrtu wiadomoci
        
        // ?
        
        // deszyfrowanie
        
        cipher.init(Cipher.DECRYPT_MODE, key, ivSpec);
        
        byte[] plainText = cipher.doFinal(cipherText, 0, ctLength);
        int    messageLength = plainText.length - hMac.getMacLength();
        
        hMac.init(hMacKey);
        hMac.update(plainText, 0, messageLength);
        
        byte[] messageHash = new byte[hMac.getMacLength()];
        System.arraycopy(plainText, messageLength, messageHash, 0, messageHash.length);
        
        System.out.println("dane odszyfrowane: " + Utils.toString(plainText, messageLength) + " wynik weryfikacji: " + MessageDigest.isEqual(hMac.doFinal(), messageHash));
    }
}
