package rozdzial3;

import java.security.MessageDigest;

/**
 * Funkcja generujca mask zgodnie z opisem w PKCS1v2.
 */
public class MGF1
{
    private MessageDigest digest;
    
    /**
     * Tworzy wersj MGF1 dla zadanej funkcji skrtu.
     * 
     * @param digest obiekt funkcji skrtu stanowicy podstaw funkcji maski
     */
    public MGF1(
        MessageDigest digest)
    {
        this.digest = digest;
    }
    
    /**
     * Przeksztaca warto typu int na cig oktetw.
     */
    private void ItoOSP(
        int     i,
        byte[]  sp)
    {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }
    
    /**
     * Generuje mask.
     * 
     * @param seed rdo bajtw wejciowych dla stanu pocztkowego funkcji skrtu
     * @param length dugo generowanej maski
     * 
     * @return tablica bajtw zawierajca mask wygenerowan algorytmem MGF1
     */
    public byte[] generateMask(
        byte[]  seed,
        int     length)
    {
        byte[]  mask = new byte[length];
        byte[]  C = new byte[4];
        int     counter = 0;
        int     hLen = digest.getDigestLength();

        digest.reset();

        while (counter < (length / hLen))
        {
            ItoOSP(counter, C);

            digest.update(seed);
            digest.update(C);

            System.arraycopy(digest.digest(), 0, mask, counter * hLen, hLen);
            
            counter++;
        }

        if ((counter * hLen) < length)
        {
            ItoOSP(counter, C);

            digest.update(seed);
            digest.update(C);

            System.arraycopy(digest.digest(), 0, mask, counter * hLen, mask.length - (counter * hLen));
        }

        return mask;
    }
    
    public static void main(
       String[] args)
       throws Exception
    {
        MGF1   mgf1 = new MGF1(MessageDigest.getInstance("SHA-1", "BC"));
        byte[]  source = new byte[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 };
        
       System.out.println(Utils.toHex(mgf1.generateMask(source, 20)));
    }
}
