package rozdzial2;

import java.security.Key;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;

public class SimpleWrapExample
{
    public static void main(
        String[]    args)
        throws Exception
    {
 
        // utworzenie opakowywanego klucza
        
        KeyGenerator generator = KeyGenerator.getInstance("AES", "BC");
        generator.init(128);

        Key keyToBeWrapped = generator.generateKey();

        System.out.println("oryginalny klucz: " + Utils.toHex(keyToBeWrapped.getEncoded()));
        
        // utworzenie opakowania i pakowanie
        
        Cipher cipher = Cipher.getInstance("AESWrap", "BC");
        
        KeyGenerator keyGen = KeyGenerator.getInstance("AES", "BC");
        keyGen.init(256);
        
        Key wrapKey = keyGen.generateKey();
        
        cipher.init(Cipher.WRAP_MODE, wrapKey);
        
        byte[] wrappedKey = cipher.wrap(keyToBeWrapped);

        System.out.println("opakowany klucz: " + Utils.toHex(wrappedKey));
        
        // odpakowanie opakowanego klucza
        
        cipher.init(Cipher.UNWRAP_MODE, wrapKey);
        
        Key key = cipher.unwrap(wrappedKey, "AES", Cipher.SECRET_KEY);

        System.out.println("odpakowany klucz: " + Utils.toHex(key.getEncoded()));
    }
}
