package rozdzial10;

import java.io.FileInputStream;
import java.security.KeyStore;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

/**
 * Klient SSL z uwierzytelnianiem klienta.
 */
public class SSLClientWithClientAuthTrustExample
    extends SSLClientExample
{
    /**
     * Tworzy kontekst SSL na podstawie tosamoci i repozytorium.
     */
    static SSLContext createSSLContext()
        throws Exception
    {
        // przygotowanie menedera kluczy z lokalnymi danymi identyfikacyjnymi
      KeyManagerFactory mgrFact = KeyManagerFactory.getInstance("SunX509");
      KeyStore clientStore = KeyStore.getInstance("PKCS12");

      clientStore.load(new FileInputStream("klient.p12"), Utils.CLIENT_PASSWORD);

      mgrFact.init(clientStore, Utils.CLIENT_PASSWORD);

      // przygotowanie menedera certyfikatw zaufanych pozwalajcego uwierzytelni serwer
      TrustManagerFactory trustFact = TrustManagerFactory.getInstance("SunX509");
      KeyStore            trustStore = KeyStore.getInstance("JKS");

      trustStore.load(new FileInputStream("skladZaufany.jks"), Utils.TRUST_STORE_PASSWORD);
      
      trustFact.init(trustStore);
      
      // utworzenie kontekstu i przygotowanie obiektu fabrykujcego gniazda
      SSLContext sslContext = SSLContext.getInstance("TLS");

      sslContext.init(mgrFact.getKeyManagers(), trustFact.getTrustManagers(), null);

      return sslContext;
    }
    
    public static void main(
        String[] args)
        throws Exception
    {
        SSLContext       sslContext = createSSLContext();
      SSLSocketFactory fact = sslContext.getSocketFactory();
        SSLSocket        cSock = (SSLSocket)fact.createSocket(Utils.HOST, Utils.PORT_NO);

        doProtocol(cSock);
    }
}
