package rozdzial10;

import java.io.FileInputStream;
import java.security.KeyStore;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

/**
 * Klient SSL z uwierzytelnianiem klienta.
 */
public class SSLClientWithClientAuthExample
    extends SSLClientExample
{
    /**
     * Tworzy kontekst SSL z tosamoci dostarczon przez obiekt KeyManager.
     */
    static SSLContext createSSLContext() 
        throws Exception
    {
        // przygotowanie menedera kluczy z lokalnymi danymi identyfikacyjnymi
      KeyManagerFactory mgrFact = KeyManagerFactory.getInstance("SunX509");
      KeyStore clientStore = KeyStore.getInstance("PKCS12");

      clientStore.load(new FileInputStream("klient.p12"), Utils.CLIENT_PASSWORD);

      mgrFact.init(clientStore, Utils.CLIENT_PASSWORD);
      
      // utworzenie kontekstu i przygotowanie obiektu fabrykujcego gniazda
      SSLContext sslContext = SSLContext.getInstance("TLS");

      sslContext.init(mgrFact.getKeyManagers(), null, null);
      
        return sslContext;
    }
    
    public static void main(
        String[] args)
        throws Exception
    {
      SSLContext       sslContext = createSSLContext();
      SSLSocketFactory fact = sslContext.getSocketFactory();
        SSLSocket        cSock = (SSLSocket)fact.createSocket(Utils.HOST, Utils.PORT_NO);

        doProtocol(cSock);
    }
}
