package rozdzial10;

import java.io.InputStream;
import java.net.URL;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;

/**
 * Klient SSL z uwierzytelnianiem po stronie klienta.
 */
public class HTTPSClientExample
    extends SSLClientWithClientAuthTrustExample
{
    /**
     * Klasa sprawdzajca, czy host przedstawi si za pomoc certyfikatu "Testowy Certyfikat Glowny".
     */
    private static class Validator
        implements HostnameVerifier
    {
        public boolean verify(String hostName, SSLSession session)
        {
            try
            {
                X500Principal hostID = (X500Principal)session.getPeerPrincipal();
                
                return hostID.getName().equals("CN=Testowy Certyfikat Glowny");
            }
            catch (Exception e)
            {
                return false;
            }
        }
    }
    
    public static void main(
        String[] args)
        throws Exception
    {
      SSLContext       sslContext = createSSLContext();
      SSLSocketFactory fact = sslContext.getSocketFactory();
      
      // ustawienie adresu URL i atrybutw poczenia
      URL url = new URL("https://"+ Utils.HOST + ":" + Utils.PORT_NO);
      
      HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
      
      connection.setSSLSocketFactory(fact);
      connection.setHostnameVerifier(new Validator());
      
      connection.connect();
      
      // odczytanie odpowiedzi
      InputStream  in = connection.getInputStream();
        
        int ch = 0;
        while ((ch = in.read()) >= 0)
        {
            System.out.print((char)ch);
        }
    }
}