data class Grocery(val name: String, val category: String,
                   val unit: String, val unitPrice: Double,
                   val quantity: Int)

fun main(args: Array<String>) {
    val groceries = listOf(Grocery("Pomidory", "Warzywa", "kg", 10.0, 3),
        Grocery("Grzyby", "Warzywa", "kg", 12.0, 1),
        Grocery("Oliwa z oliwek", "Spiżarka", "Butelka", 19.0, 1),
        Grocery("Lody", "Mrożonki", "Opakowanie", 14.0, 2),
        Grocery("Obwarzanki", "Wypieki", "Opakowanie", 3.5, 2))

    groceries.groupBy { it.category }.forEach {
        println(it.key)
        it.value.forEach { println(" ${it.name}") }
    }

    val ints = listOf(1, 2, 3)
    val sumOfInts = ints.fold(0) { runningSum, item -> runningSum + item }
    println("sumOfInts: $sumOfInts")

    val productOfInts = ints.fold(1) { runningProduct, item -> runningProduct * item }
    println("productOfInts: $productOfInts")

    val names = groceries.fold("") { string, item -> string + " ${item.name}" }
    println("names: $names")

    val changeFrom100 = groceries.fold(100.0) { change, item
        -> change - item.unitPrice * item.quantity }
    println("changeFrom100: $changeFrom100")

}
