open class Animal {
    open val image = ""
    open val food = ""
    open val habitat = ""
    var hunger = 10

    open fun makeNoise() {
        println("Zwierzę wydaje dźwięki.")
    }

    open fun eat() {
        println("Zwierzę posila się.")
    }

    open fun roam() {
        println("Zwierzę wałęsa się.")
    }

    open fun sleep() {
        println("Zwierzę śpi.")
    }
}

class Hippo : Animal() {
    override val image = "hippo.jpg"
    override val food = "trawa"
    override val habitat = "woda"

    override fun makeNoise() {
        println("Hrumm! Hrum!")
    }

    override fun eat() {
        println("Głównym pożywieniem hipopotamów jest $food.")
    }
}


open class Canine : Animal() {
    override fun roam() {
        println("Psowate wałęsa się.")
    }
}

class Wolf : Canine() {
    override val image = "wolf.jpg"
    override val food = "mięso"
    override val habitat = "lasy"
    override fun makeNoise() {
        println("Aaauuuuuu!")
    }

    override fun eat() {
        println("Głównym pożywieniem wilków jest $food.")
    }
}

class Vet {
    fun giveShot(animal: Animal) {
        // Kod wykonujący jakieś operacje medyczne
        animal.makeNoise()
    }
}

fun main(args: Array<String>) {
    val animals = arrayOf(Hippo(), Wolf())
    for (item in animals) {
        item.roam()
        item.eat()
    }
    val vet = Vet()
    val wolf = Wolf()
    val hippo = Hippo()
    vet.giveShot(wolf)
    vet.giveShot(hippo)
}