package ch06.ex1_4_2_ElvisOperator1

class Address(val streetAddress: String, val zipCode: Int,
              val city: String, val country: String)

class Company(val name: String, val address: Address?)

class Person(val name: String, val company: Company?)

fun printShippingLabel(person: Person) {
    val address = person.company?.address
      ?: throw IllegalArgumentException("Brak adresu")
    with (address) {
        println(streetAddress)
        println("$zipCode $city, $country")
    }
}

fun main(args: Array<String>) {
    val address = Address("Kościuszki 1c", "44-100", "Gliwice", "Polska")
    val helion = Company("Helion", address)
    val person = Person("Dariusz", helion)
    printShippingLabel(person)
    printShippingLabel(Person("Andrzej", null))
}
