package ch04.main

class Button : Clickable, Focusable {
    override fun click() = println("Kliknąłeś mnie")

    override fun showOff() {
        super<Clickable>.showOff()
        super<Focusable>.showOff()
    }
}

interface Clickable {
    fun click()
    fun showOff() = println("Można mnie klikać!")
}

interface Focusable {
    fun setFocus(b: Boolean) =
        println("I ${if (b) "Zostałem" else "Nie zostałem"} wyróżniony.")

    fun showOff() = println("Można mnie wyróżniać!")
}

fun main(args: Array<String>) {
    val button = Button()
    button.showOff()
    button.setFocus(true)
    button.click()
}
