package ch03.ex6_4_LocalFunctionsAndExtensions3

class User(val id: Int, val name: String, val address: String)

fun User.validateBeforeSave() {
    fun validate(value: String, fieldName: String) {
        if (value.isEmpty()) {
            throw IllegalArgumentException(
               "Nie można zapisać użytkownika $id: brak $fieldName")
        }
    }

    validate(name, "nazwiska")
    validate(address, "adresu")
}

fun saveUser(user: User) {
    user.validateBeforeSave()

    // Zapisanie danych użytkownika w bazie.
}

fun main(args: Array<String>) {
    saveUser(User(1, "", ""))
}
