import time
import os

# Import modułu ADC
from OmegaExpansion import AdcExp

# utwórz obiekt ADC
adc = AdcExp.AdcExp()

# pętla główna
while 1:
	# odczytaj kanały ADC
	a0 = adc.read_voltage(0)
	# a1 = adc.read_voltage(1)
	a2 = adc.read_voltage(2)
	# a3 = adc.read_voltage(3)

	# zamień wartość napięcia czujnika temperatury na temperaturę
	temp = (a0 - 0.5) * 100

	# zamień wartość napięcia czujnika natężenia światła na luksy
	rPhoto = 5.0 / a2 * 1000 - 1000
	lx = 500/(rPhoto/1000)

	# wyczyść ekran
	os.system('cls' if os.name == 'nt' else 'clear')

	# drukuj wartości czujników
	print('''
Temperatura\t\t| %.02f C
Natężenie światła\t| %d lx
'''%(temp, lx))

	# odczekaj chwilkę
	time.sleep(0.5)