/*
 * Copyright 2020 Wuyi Chen.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kafkadefinitiveguide.producer.partitioner.custompartitioner;

import java.util.List;
import java.util.Map;

import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.Utils;

/**
 * Niestandardowy partycjoner do kierowania określonych kluczy do konkretnych partycji
 *
 * @author  Wuyi Chen
 * @date    06/03/2020
 * @version 1.0
 * @since   1.0
 */
public class BananaPartitioner implements Partitioner {
    public void configure(Map<String, ?> configs) {}

    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
        int numPartitions = partitions.size();

        if ((keyBytes == null) || (!(key instanceof String))) {                // Oczekujemy tylko kluczy typu String, dlatego w przeciwnym razie rzucamy wyjątek
            throw new IllegalArgumentException("Oczekujemy, że wszystkie komunikaty będą miały jako klucz nazwę klienta ");
        }

        if (((String) key).equals("Banan")) {                                 // Banan będzie zawsze przydzielany do ostatniej partycji
            return numPartitions - 1;                
        }

        return (Math.abs(Utils.murmur2(keyBytes)) % (numPartitions - 1));      // Pozostałe rekordy będą mieszane do reszty partycji
    }

    public void close() {}
}
