import java.security.*;
import javax.security.auth.*;
import javax.security.auth.login.*;

/**
   Program uwierzytelnia uytkownika przez zalogowanie 
   do systemu i nastpnie wykonuje SysPropAction
   korzystajc z pozwole przyznanych uytkownikowi.
*/
public class AuthTest
{
   public static void main(final String[] args)
   {
      try 
      {
         System.setSecurityManager(new SecurityManager());
         LoginContext context = new LoginContext("Login1");
         context.login();
         System.out.println("Sukces uwierzytelniania.");
         Subject subject = context.getSubject();
         System.out.println("subject=" + subject);
         PrivilegedAction action = new SysPropAction("user.home");
         Object result = Subject.doAsPrivileged(subject, action, null);
         System.out.println(result);
         context.logout();
      } 
      catch (LoginException e) 
      {
         e.printStackTrace();
      }      
   }
}
