/**
   @version 1.01 2004-08-24
   @author Cay Horstmann
*/

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import java.util.*;
import javax.print.*;
import javax.swing.*;

/**
   Program demonstrujcy wykorzystanie usug drukowania.
   Drukuje obrazek w formacie GIF za pomoc jednej z usug
   dostpnych dla tego rodzaju dokumentu (wybranej przez uytkownika).
*/
public class PrintServiceTest
{
   public static void main(String[] args)
   {
      JFrame frame = new PrintServiceFrame();
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.setVisible(true);
   }
}

/**
   Ramka prezentujca drukowany obrazek. Posiada menu
   umoliwiajce wybr pliku, wybr usugi drukowania 
   i wydruk pliku.
*/
class PrintServiceFrame extends JFrame
{
   public PrintServiceFrame()
   {
      setTitle("PrintServiceTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // konstruuje pasek menu
      JMenuBar menuBar = new JMenuBar();
      setJMenuBar(menuBar);

      JMenu menu = new JMenu("File");
      menuBar.add(menu);

      JMenuItem openItem = new JMenuItem("Open");
      menu.add(openItem);
      openItem.addActionListener(new
         ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               openFile();
            }
         });

      JMenuItem printItem = new JMenuItem("Print");
      menu.add(printItem);
      printItem.addActionListener(new
         ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               printFile();
            }
         });

      JMenuItem exitItem = new JMenuItem("Exit");
      menu.add(exitItem);
      exitItem.addActionListener(new
         ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               System.exit(0);
            }
         });

      menu = new JMenu("Printer");
      menuBar.add(menu);
      DocFlavor flavor = DocFlavor.INPUT_STREAM.GIF;
      addPrintServices(menu, flavor);

      // do wywietlania zawartoci pliku graficznego 
      // wykorzystuje etykiet

      label = new JLabel();
      add(label);
   }

   /**
      Dodaje usugi drukowania do menu
      @param menu menu, w ktrym umieszczane s usugi
      @param flavor rodzaj dokumentu, ktrego wydruk umoliwiaj usugi
   */
   public void addPrintServices(JMenu menu, DocFlavor flavor)
   {      
      PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
      ButtonGroup group = new ButtonGroup();
      for (int i = 0; i < services.length; i++)
      {
         final PrintService service = services[i];
         JRadioButtonMenuItem item = new JRadioButtonMenuItem(service.getName());
         menu.add(item);
         if (i == 0) 
         {
            item.setSelected(true);
            currentService = service;
         }
         group.add(item);
         item.addActionListener(new
            ActionListener()
            {
               public void actionPerformed(ActionEvent event)
               {
                  currentService = service;
               }
            });
      }
   }

   /**
      Otwiera plik w formacie GIF i wywietla jego zawarto.
   */
   public void openFile()
   {
      // konstruuje okno dialogowe wyboru pliku
      JFileChooser chooser = new JFileChooser();
      chooser.setCurrentDirectory(new File("."));
      
      // akceptuje pliki o rozszerzeniu .gif
      chooser.setFileFilter(new
         javax.swing.filechooser.FileFilter()
         {
            public boolean accept(File f)
            {
               return f.getName().toLowerCase().endsWith(".gif") || f.isDirectory();
            }

            public String getDescription() { return "GIF Images"; }
         });

      // wywietla okno dialogowe wyboru pliku
      int r = chooser.showOpenDialog(PrintServiceFrame.this);
      
      // jeli plik zosta wybrany, to staje si ikon etykiety
      if(r == JFileChooser.APPROVE_OPTION)
      {
         fileName = chooser.getSelectedFile().getPath();
         label.setIcon(new ImageIcon(fileName));
      }
   }

   /**
      Drukuje zawarto pliku, korzystajc z biecej usugi.
   */
   public void printFile()
   {
      try
      {
         if (fileName == null) return;
         if (currentService == null) return;
         FileInputStream in = new FileInputStream(fileName);
         DocFlavor flavor = DocFlavor.INPUT_STREAM.GIF;      
         Doc doc = new SimpleDoc(in, flavor, null);
         DocPrintJob job = currentService.createPrintJob();
         job.print(doc, null);      
      }
      catch (FileNotFoundException e)
      {
         JOptionPane.showMessageDialog(this, e);
      }
      catch (PrintException e)
      {  
         JOptionPane.showMessageDialog(this, e);
      }
   }

   private JLabel label;
   private String fileName;
   private PrintService currentService;
   private static final int DEFAULT_WIDTH = 300;
   private static final int DEFAULT_HEIGHT = 400;
}

