/**
   @version 1.02 2004-08-21
   @author Cay Horstmann
*/

import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

/**
   Program demonstrujcy sposb rysowania 
   komrek drzewa na przykadzie drzewa klas i ich
   klas bazowych.
*/
public class ClassTree
{  
   public static void main(String[] args)
   {  
      JFrame frame = new ClassTreeFrame();
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.setVisible(true);
   }
}

/**
   Ramka zawierajca drzewo klas oraz pole tekstowe 
   i przycisk umoliwiajce dodawanie klas do drzewa.
*/
class ClassTreeFrame extends JFrame
{  
   public ClassTreeFrame()
   {  
      setTitle("ClassTree");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // korzeniem drzewa jest klasa Object
      root = new DefaultMutableTreeNode(java.lang.Object.class);
      model = new DefaultTreeModel(root);
      tree = new JTree(model);

      // korzeniem drzewa jest klasa Object
      addClass(getClass());

      // tworzy ikony wzw
      ClassNameTreeCellRenderer renderer = new ClassNameTreeCellRenderer();
      renderer.setClosedIcon(new ImageIcon("red-ball.gif"));
      renderer.setOpenIcon(new ImageIcon("yellow-ball.gif"));
      renderer.setLeafIcon(new ImageIcon("blue-ball.gif"));
      tree.setCellRenderer(renderer);

      add(new JScrollPane(tree), BorderLayout.CENTER);

      addTextField();
   }

   /**
      Dodaje pole tekstowe i przycisk.
   */
   public void addTextField()
   {
      JPanel panel = new JPanel();

      ActionListener addListener = new
         ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {  
               // dodaje do drzewa klas, ktrej nazwa znajduje si 
               // w polu tekstowym

               try
               {  
                  String text = textField.getText();
                  addClass(Class.forName(text)); // usuwa tekst z pola tekstowego
                  textField.setText("");
               }
               catch (ClassNotFoundException e)
               {  
                  JOptionPane.showMessageDialog(null, "Class not found");
               }
            }
         };

      // tworzy pole tekstowe
      textField = new JTextField(20);
      textField.addActionListener(addListener);
      panel.add(textField);

      JButton addButton = new JButton("Add");
      addButton.addActionListener(addListener);
      panel.add(addButton);

      add(panel, BorderLayout.SOUTH);
   }

   /**
      Znajduje obiekt w drzewie.
      @param obj szukany obiekt
      @return wze zawierajcy obiekt lub null,
      jeli obiektu nie ma w drzewie
   */
   public DefaultMutableTreeNode findUserObject(Object obj)
   {  
      // znajduje wze zawierajcy dany obiekt uytkownika
      Enumeration e = root.breadthFirstEnumeration();
      while (e.hasMoreElements())
      {  
         DefaultMutableTreeNode node = (DefaultMutableTreeNode) e.nextElement();
         if (node.getUserObject().equals(obj))
            return node;
      }
      return null;
   }

   /**
      Dodaje do drzewa klas i jej klasy bazowe,
      ktrych nie ma jeszcze w drzewie.
      @param c dodawana klas
      @return nowo dodany wze.
   */
   public DefaultMutableTreeNode addClass(Class c)
   {  
      // dodaje klas do drzewa

      // pomija typy, ktre nie s klasami
      if (c.isInterface() || c.isPrimitive()) return null;

      // jeli klasa znajduje si ju w drzewie, to zwraca jej wze
      DefaultMutableTreeNode node = findUserObject(c);
      if (node != null) return node;

      // klasa nie znajduje si w drzewie
      // najpierw naley doda do drzewa jej klasy bazowe


      Class s = c.getSuperclass();

      DefaultMutableTreeNode parent;
      if (s == null)
         parent = root;
      else
         parent = addClass(s);

      // dodaje klas jako wze podrzdny
      DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(c);
      model.insertNodeInto(newNode, parent, parent.getChildCount());

      // sprawia, e wze jest widoczny
      TreePath path = new TreePath(model.getPathToRoot(newNode));
      tree.makeVisible(path);

      return newNode;
   }

   private DefaultMutableTreeNode root;
   private DefaultTreeModel model;
   private JTree tree;
   private JTextField textField;
   private static final int DEFAULT_WIDTH = 400;
   private static final int DEFAULT_HEIGHT = 300;
}

/**
   Klasa opisujca wzy drzewa czcionk zwyk lub pochylon
   (w przypadku klas abstrakcyjnych).
*/
class ClassNameTreeCellRenderer extends DefaultTreeCellRenderer
{  
   public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, 
      boolean expanded, boolean leaf, int row, boolean hasFocus)
   {  
      super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
      // pobiera obiekt uytkownika
      DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
      Class c = (Class) node.getUserObject();

      // przy pierwszym uyciu tworzy czcionk
      // pochy odpowiadajc danej czcionce prostej

      if (plainFont == null)
      {  
         plainFont = getFont();
         // obiekt rysujcy komrk drzewa wywoywany jest czasami
         // dla etykiety, ktra nie posiada okrelonej czcionki (null).
         if (plainFont != null) italicFont = plainFont.deriveFont(Font.ITALIC);
      }

      // wybiera czcionk pochy, jeli klasa jest abstrakcyjna
      if ((c.getModifiers() & Modifier.ABSTRACT) == 0)
         setFont(plainFont);
      else
         setFont(italicFont);
      return this;
   }

   private Font plainFont = null;
   private Font italicFont = null;
}
