/**
   @version 1.20 2004-08-15
   @author Cay Horstmann
*/

import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.activation.*;
import java.util.*;
import javax.naming.*;

/**
   Program serwera aktywujcy dwa zdalne obiekty i rejestrujcy je.
*/
public class ProductActivator
{  
   public static void main(String args[])
   {  
      try
      {  
         System.out.println("Tworzy deskryptory aktywacji...");

         Properties props = new Properties();
         // uywa pliku server.policy z biecego katalogu
         props.put("java.security.policy", new File("server.policy").getCanonicalPath());
         ActivationGroupDesc group = new ActivationGroupDesc(props, null);
         ActivationGroupID id = ActivationGroup.getSystem().registerGroup(group);
         MarshalledObject p1param = new MarshalledObject("Blackwell Toaster");
         MarshalledObject p2param = new MarshalledObject("ZapXpress Microwave Oven");

         String classDir = ".";
         // przeksztaca katalog klas w URL pliku
         // dla potrzeb tego programu zakadamy, e klasy
         // znajduj si w biecym katalogu
         // uywa metody toURI pozwalajcej pomin odstpy i inne znaki specjalne w nazwach plikw
         String classURL = new File(classDir).getCanonicalFile().toURI().toString();

         ActivationDesc desc1 = new ActivationDesc(id, "ProductImpl", classURL, p1param);
         ActivationDesc desc2 = new ActivationDesc(id, "ProductImpl", classURL, p2param);
         
         Product p1 = (Product) Activatable.register(desc1);
         Product p2 = (Product) Activatable.register(desc2);

         System.out.println("Wizanie nazw...");
         Context namingContext = new InitialContext();
         namingContext.bind("rmi:toaster", p1);
         namingContext.bind("rmi:microwave", p2);         
         System.out.println("Koniec...");
      }
      catch (Exception e)
      {  
         e.printStackTrace();
      }
   }
}

