/**
   @version 1.30 2004-08-01
   @author Cay Horstmann
*/

/** 
   Program ilustruje uszkodzenie danych na skutek rwnoczesnego dostpu
   wielu wtkw do tej samej struktury danych
*/
public class UnsynchBankTest
{  
   public static void main(String[] args)
   {  
      Bank b = new Bank(NACCOUNTS, INITIAL_BALANCE);
      int i;
      for (i = 0; i < NACCOUNTS; i++)
      {  
         TransferRunnable r = new TransferRunnable(b, i, INITIAL_BALANCE);
         Thread t = new Thread(r);
         t.start();
      }
   }

   public static final int NACCOUNTS = 100;
   public static final double INITIAL_BALANCE = 1000;
}

/**
   Bank o pewnej liczbie kont.
*/
class Bank
{ 
   /**
      
      Tworzy bank.
      @param n liczba kont
      @param initialBalance pocztkowy stan kadego konta
   */
   public Bank(int n, double initialBalance)
   {  
      accounts = new double[n];
      for (int i = 0; i < accounts.length; i++)
         accounts[i] = initialBalance;
   }

   /**
      Przelewa pienidze z jednego konta na drugie.
      @param from konto nadawcy
      @param to konto odbiorcy
      @param amount kwota przelewu
   */
   public void transfer(int from, int to, double amount)
   {  
      if (accounts[from] < amount) return;
      System.out.print(Thread.currentThread());      
      accounts[from] -= amount;
      System.out.printf(" %10.2f from %d to %d", amount, from, to);
      accounts[to] += amount;
      System.out.printf(" Total Balance: %10.2f%n", getTotalBalance());
   }

   /**
      Zwraca saldo banku.
      @return saldo banku
   */
   public double getTotalBalance()
   {  
      double sum = 0;

      for (double a : accounts)
         sum += a;

      return sum;
   }

   /**
      Zwraca liczb kont w banku.
      @return liczba kont
   */
   public int size()
   {
      return accounts.length;
   }

   private final double[] accounts;
}

/**
   Klasa wykonujca przelewy pomidzy kontami w osobnych wtkach.
*/
class TransferRunnable implements Runnable
{ 
   /**
      Konstruktor.
      @param b bank pomidzy kontami ktrego dokonywane s przelewy
      @param from konto nadawcy
      @param max maksymalna kwota przelewu
   */
   public TransferRunnable(Bank b, int from, double max)
   {  
      bank = b;
      fromAccount = from;
      maxAmount = max;
   }

   public void run()
   {  
      try
      {  
         while (true)
         {  
            int toAccount = (int) (bank.size() * Math.random());
            double amount = maxAmount * Math.random();
            bank.transfer(fromAccount, toAccount, amount);
            Thread.sleep((int) (DELAY * Math.random()));
         }
      }
      catch (InterruptedException e) {}
   }

   private Bank bank;
   private int fromAccount;
   private double maxAmount;
   private int DELAY = 10;
}

