/**
   @version 1.03 2004-08-22
   @author Cay Horstmann
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

/**
   Program testujcy dziaanie monitora postpu strumienia wejciowego.
*/
public class ProgressMonitorInputStreamTest
{  
   public static void main(String[] args)
   {  
      JFrame frame = new TextFrame();
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.setVisible(true);      
   }
}

/**
   Ramka wyposaona w menu umoliwiajce zaadowanie
   pliku tekstowego i pole tekstowe pokazujce jego zawarto.
   Pole tekstowe jest tworzone i inicjowane po zakoczeniu
   wczytywania pliku, aby unikn migania.
*/
class TextFrame extends JFrame
{  
   public TextFrame()
   {  
      setTitle("ProgressMonitorInputStreamTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // tworzy menu

      JMenuBar menuBar = new JMenuBar();
      setJMenuBar(menuBar);
      JMenu fileMenu = new JMenu("File");
      menuBar.add(fileMenu);
      openItem = new JMenuItem("Open");
      openItem.addActionListener(new
         ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               try
               {
                  openFile();
               }
               catch(IOException exception)
               {  
                  exception.printStackTrace();
               }
            }
         });

      fileMenu.add(openItem);
      exitItem = new JMenuItem("Exit");
      exitItem.addActionListener(new
         ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               System.exit(0);
            }
         });
      fileMenu.add(exitItem);
   }

   /**
      Umoliwia uytkownikowi wybranie pliku, ktrego zawarto
      zostanie pokazana w polu tekstowym.
   */
   public void openFile() throws IOException
   {  
      JFileChooser chooser = new JFileChooser();
      chooser.setCurrentDirectory(new File("."));
      chooser.setFileFilter(
         new javax.swing.filechooser.FileFilter()
            {  
               public boolean accept(File f)
               {  
                  String fname = f.getName().toLowerCase();
                  return fname.endsWith(".txt") || f.isDirectory();
               }
               public String getDescription()
               { 
                  return "Text Files"; 
               }
            });

      int r = chooser.showOpenDialog(this);
      if (r != JFileChooser.APPROVE_OPTION) return;
      final File f = chooser.getSelectedFile();

      // tworzy strumie i sekwencj filtrw odczytu
      
      FileInputStream fileIn = new FileInputStream(f);
      ProgressMonitorInputStream progressIn
         = new ProgressMonitorInputStream(this, "Reading " + f.getName(), fileIn);
      final Scanner in = new Scanner(progressIn);
      
      // monitorowana operacja musi by wykonywana w osobnym wtku 

      Runnable readRunnable = new
         Runnable()
         {  
            public void run()
            {             
               final JTextArea textArea = new JTextArea();  
                  
               while (in.hasNextLine())
               {
                  String line = in.nextLine();         
                  textArea.append(line);
                  textArea.append("\n");
               }
               in.close();
               
               // aktualizuje zawarto panela w wtku obsugi zdarze
               // interfejsu uytkownika
               EventQueue.invokeLater(new 
                  Runnable()
                  {  
                     public void run()
                     {  
                        setContentPane(new JScrollPane(textArea));
                        validate();
                     }
                  });
               
            }
         };

      Thread readThread = new Thread(readRunnable);
      readThread.start();
   }

   private JMenuItem openItem;
   private JMenuItem exitItem;

   public static final int DEFAULT_WIDTH = 300;
   public static final int DEFAULT_HEIGHT = 200;
}

