/**
   @version 1.11 2001-07-10
   @author Cay Horstmann
*/

import java.rmi.*;
import java.rmi.server.*;
import javax.naming.*;

/**
   Tworzy obiekty serwera, rejestruje je
   i oczekuje na zdalne wywoania metod przez klientw.
*/
public class WarehouseServer
{  
   public static void main(String[] args)
   {  
      try
      {  
         System.out.println("Tworzy implementacje serwera...");
         WarehouseImpl w = new WarehouseImpl();
         w.add(new ProductImpl("Blackwell Toaster", Product.BOTH, 18, 200, "Gospodarstwo domowe"));
         w.add(new ProductImpl("ZapXpress Microwave Oven", Product.BOTH, 18, 200, "Gospodarstwo domowe"));
         w.add(new ProductImpl("DirtDigger Steam Shovel", Product.MALE, 20, 60, "Ogrodnictwo"));
         w.add(new ProductImpl("U238 Weed Killer", Product.BOTH, 20, 200, "Ogrodnictwo"));
         w.add(new ProductImpl("Persistent Java Fragrance", Product.FEMALE, 15, 45, "Uroda"));
         w.add(new ProductImpl("Rabid Rodent Computer Mouse", Product.BOTH, 6, 40, "Komputery"));
         w.add(new ProductImpl("My first Espresso Maker", Product.FEMALE, 6, 10, "Gospodarstwo domowe"));
         w.add(new ProductImpl("JavaJungle Eau de Cologne", Product.MALE, 15, 45, "Uroda"));
         w.add(new ProductImpl("FireWire Espresso Maker", Product.BOTH, 20, 50, "Komputery"));
         w.add(new ProductImpl("Learn Bad Java Habits in 21 Days Book", Product.BOTH, 20, 200, 
            "Komputery"));

         System.out.println("Binding server implementations to registry...");
         Context namingContext = new InitialContext();
         namingContext.bind("rmi:central_warehouse", w);

         System.out.println("Waiting for invocations from clients...");
      }
      catch (Exception e)
      {  
         e.printStackTrace();
      }
   }
}

