/**
   @version 1.01 2004-09-24
   @author Cay Horstmann
*/

import java.sql.*;
import java.io.*;
import java.util.*;

/**
   Program sprawdzajcy poprawno konfiguracji
   bazy danych i sterownika JDBC.
*/
class TestDB
{  
   public static void main (String args[])
   {  
      try
      {  
         runTest();
      }
      catch (SQLException ex)
      {  
         while (ex != null)
         {  
            ex.printStackTrace();
            ex = ex.getNextException();
         }
      }
      catch (IOException ex)
      {  
         ex.printStackTrace();
      }
   }

   /**
      Wykonuje test polegajcy na utworzeniu tabeli, wstawieniu do niej wartoci, prezentacji zawartoci, usuniciu tabeli.
   */
   public static void runTest()
      throws SQLException, IOException
   {
      Connection conn = getConnection();
      try
      {
         Statement stat = conn.createStatement();
         
         stat.execute("CREATE TABLE Greetings (Message CHAR(20))");
         stat.execute("INSERT INTO Greetings VALUES ('Hello, World!')");
         
         ResultSet result = stat.executeQuery("SELECT * FROM Greetings");
         result.next();
         System.out.println(result.getString(1));
         stat.execute("DROP TABLE Greetings");      
      }
      finally
      {
         conn.close();
      }
   }

   /**
      Nawizuje poczenie, korzystajc
      z waciwoci w pliku database.properties
      @return poczenie do bazy danych
   */
   public static Connection getConnection()
      throws SQLException, IOException
   {  
      Properties props = new Properties();
      FileInputStream in = new FileInputStream("database.properties");
      props.load(in);
      in.close();

      String drivers = props.getProperty("jdbc.drivers");
      if (drivers != null)
         System.setProperty("jdbc.drivers", drivers);
      String url = props.getProperty("jdbc.url");
      String username = props.getProperty("jdbc.username");
      String password = props.getProperty("jdbc.password");

      return DriverManager.getConnection(url, username, password);
   }
}



