/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import junit.framework.*;
import org.easymock.MockControl;

public class TestJukebox extends TestCase {

  private Jukebox     mockJukebox;
  private MockControl mockJukebox_control;

  protected void setUp() {
    // Tworzy uchwyt sterujcy dla obiektu imitacji
    mockJukebox_control = 
      MockControl.createControl(Jukebox.class);
    
    // Oraz sam obiekt imitacji
    mockJukebox = 
      (Jukebox) mockJukebox_control.getMock();
  }

  public void testEasyMockDemo() {
    
    // Konfiguruje obiekt imitacji
    // poprzez wywoania metod, ktre 
    // maj by obsugiwane
    mockJukebox.getCurrentSong();
    mockJukebox_control.setReturnValue(
                        "King Crimson -- Epitaph");
      
    // Dziki temu nie musimy si przejmowa
    // pozostaymi kilkudziesicioma metodami
    // interfejsu Jukebox...
      
    // Przecza z trybu nagrywania do odtwarzania
    mockJukebox_control.replay();
    
    // Teraz mona ju uywa obiektu imitacji:
    assertEquals("King Crimson -- Epitaph", 
                 mockJukebox.getCurrentSong());
  }

}
