/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import junit.framework.*;

public class TestClassTwo extends TestCase {
  
  public TestClassTwo(String method) {
    super(method);
  }
  
  // Wykonanie tego testu zabiera kilka godzin...
  public void testLongRunner() {
    TSP tsp = new TSP(); // Zaaduj dane o miastach

    // Znajd najkrtsz drog dla pierwszych 50
    assertEquals(2300, tsp.shortestPath(50)); 
  }
  
  public void testShortTest() {
    TSP tsp = new TSP(); // Zaaduj dane o miastach

    // Znajd najkrtsz drog dla pierwszych 5
    assertEquals(140, tsp.shortestPath(5)); 
  }
  
  public void testAnotherShortTest() {
    TSP tsp = new TSP(); // Zaaduj dane o miastach

    // Znajd najkrtsz drog dla pierwszych 10  
    assertEquals(586, tsp.shortestPath(10));
  }
  
  public static Test suite() {
    TestSuite suite = new TestSuite();
    // Zestaw najkrtszych testw
    suite.addTest(
          new TestClassTwo("testShortTest"));
    suite.addTest(
          new TestClassTwo("testAnotherShortTest"));
    return suite;
  }
  
}
