package com.skatestown.xml;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import com.skatestown.data.PO;
import com.skatestown.data.POItem;
import com.skatestown.data.Address;
import com.skatestown.data.Invoice;
import com.skatestown.data.InvoiceItem;
import com.skatestown.data.BusinessDocument;

public class Deserializer {
	static final String PO_NS = "http://www.skatestown.com/ns/po";
	static final String INVOICE_NS = "http://www.skatestown.com/ns/invoice";
	
	String namespaceURI;
	
	protected Deserializer(String namespaceURI) {
		this.namespaceURI = namespaceURI;
	}
	
	public static PO createPO(Element elem) {
		Deserializer des = new Deserializer(PO_NS);
		return des._createPO(elem);
	}
	
	public static Invoice createInvoice(Element elem) {
		Deserializer des = new Deserializer(INVOICE_NS);
		return des._createInvoice(elem);
	}
	
	protected String[] getValues(Element elem, String name) {
		NodeList list = elem.getElementsByTagNameNS(namespaceURI, name );
		if (list == null || list.getLength() == 0)
			return null;
		
		String[]  result = new String[ list.getLength() ];
		for (int i = 0;i < list.getLength(); i++) {
			elem = (Element) list.item(i);
			result[i] = elem.getFirstChild().getNodeValue();
		}
		return result;
	}
	
	protected String getValue(Element elem, String name) {
		String[] result = getValues(elem, name);
		if (result == null)
            return null;
		return result[0];
	}
	
	protected double getValueAsDouble(Element elem, String name) {
		return Double.parseDouble(getValue(elem, name));
	}
	
	protected Element[] getElements(Element elem, String name) {
		NodeList list = elem.getElementsByTagNameNS(namespaceURI, name);
        int length = list.getLength();
		if (list == null || length == 0)
			return null;
		
		Element[] result = new Element[length];
		for (int i = 0; i < length; i++)
			result[i] = (Element)list.item(i);
		return result;
	}
	
	protected Element getElement(Element elem, String name) {
		Element[] result = getElements(elem, name);
		if (result == null)
            return null;
		return result[0];
	}
	
	protected void readDocument(BusinessDocument doc, Element elem) {
		doc.setId(Integer.parseInt(elem.getAttribute("id")));
		doc.setDate(elem.getAttribute("submitted"));
		
		doc.setBillTo(createAddress(getElement(elem, "billTo")));
		doc.setShipTo(createAddress(getElement(elem, "shipTo")));
	}
	
	protected void readItem(POItem item, Element elem) {
		item.setSKU(elem.getAttribute("sku"));
		item.setQuantity(Integer.parseInt(elem.getAttribute("quantity")));
		item.setDescription(getValue(elem, "description"));
	}
	
	protected Address createAddress(Element elem) {
		Address addr = new Address();
		addr.setName(getValue(elem, "name"));
		addr.setCompany(getValue(elem, "company"));
		addr.setStreet(getValues(elem, "street"));
		addr.setCity(getValue(elem, "city"));
		addr.setState(getValue(elem, "state"));
		addr.setPostalCode(getValue(elem, "postalCode"));
		addr.setCountry(getValue(elem, "country"));
		return addr;
	}
	
	protected PO _createPO(Element elem) {
		PO po = new PO();
		
		readDocument(po, elem);
		
		Element[] orderItems = getElements(elem, "item");
		POItem[] items = new POItem[orderItems.length];
		for (int i = 0; i < items.length; i++) {
			POItem item = new POItem();
			readItem(item, orderItems[i]);
			items[i] = item;
		}
		po.setItems(items);
		
		return po;
	}

	protected Invoice _createInvoice(Element elem) {
		Invoice invoice = new Invoice();
		
		readDocument(invoice, elem);
		
		Element[] invoiceItems = getElements(elem, "item");
		InvoiceItem[] items = new InvoiceItem[invoiceItems.length];
		for (int i = 0; i < items.length; i++) {
			InvoiceItem item = new InvoiceItem();
			readItem(item, invoiceItems[i]);
			item.setUnitPrice(Double.parseDouble(elem.getAttribute("unitPrice")));
			items[i] = item;
		}
		invoice.setItems(items);

		invoice.setTax(getValueAsDouble(elem, "tax"));
		invoice.setShippingAndHandling(getValueAsDouble(elem, "shippingAndHandling"));
		invoice.setTotalCost(getValueAsDouble(elem, "totalCost"));

		return invoice;
	}
}
