package com.skatestown.backend;

//import java.io.*;
//import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import com.skatestown.data.Product;

public class ProductDB {
    Product[] products;
    
    public ProductDB(Document doc) throws Exception {
        NodeList list = doc.getElementsByTagName("product");
        int length = list.getLength();
        products = new Product[length];
        for (int i = 0; i < length; i++) {
            Element elem = (Element)list.item(i);
            
            Product p = (products[i] = new Product());
            p.setSKU(getValue(elem, "sku"));
            p.setName(getValue(elem, "name"));
            p.setType(getValue(elem, "type"));
            p.setDescription(getValue(elem, "desc"));
            p.setUnitPrice(Double.parseDouble(getValue(elem, "price")));
            p.setNumInStock(Integer.parseInt(getValue(elem, "inStock")));
        }
    }
    
    public Product getBySKU(String sku) {
        Product[] list = getProducts();
        
        for (int i = 0; i < list.length; i++)
            if (sku.equals(list[i].getSKU()))
                return list[i];
        return null;
    }
    
    public Product[] getProducts() {
        return products;
    }

    private String getValue(Element elem, String name) {
        NodeList l = elem.getElementsByTagName(name);
        if (l == null || l.getLength() == 0)
            return null;
        elem = (Element)l.item(0);
        return elem.getFirstChild().getNodeValue();
    }
}
