package com.skatestown.backend;

import com.skatestown.data.PO;
import com.skatestown.data.POItem;
import com.skatestown.data.Invoice;
import com.skatestown.data.InvoiceItem;
import com.skatestown.data.Product;
import com.skatestown.xml.Deserializer;

public class POProcessor {
	ProductDB db;
	
	public POProcessor(ProductDB db) {
		this.db = db;
	}
	
	public Invoice processPO(PO po) throws Exception {
		Invoice invoice = new Invoice();
		
		invoice.setId(po.getId());
		invoice.setDate(po.getDate());
		invoice.setBillTo(po.getBillTo());
		invoice.setShipTo(po.getShipTo());
		
		double totalCost = 0;
		
		POItem[] poItems = po.getItems();
		InvoiceItem[] items = new InvoiceItem[poItems.length];
		invoice.setItems(items);
		for (int i = 0; i < items.length; i++) {
			InvoiceItem item = new InvoiceItem();
			items[i] = item;
			
			item.setSKU(poItems[i].getSKU());
			item.setQuantity(poItems[i].getQuantity());
			
			Product prod = db.getBySKU(item.getSKU());
			if (prod == null) {
				throw new Exception("Product SKU " + item.getSKU() +
									" is not in stock.");
			} else if (prod.getNumInStock() < item.getQuantity()) {
				throw new Exception("We only have " + item.getQuantity() +
								    " of product SKU " + item.getSKU() +
                                    " in stock.");
			}
			
			item.setUnitPrice(prod.getUnitPrice());
			item.setDescription(prod.getDescription());
			
			totalCost += item.getUnitPrice() * item.getQuantity();
		}
		
		// Calculate 5% tax
		double tax = 0.05 * totalCost;
		// Add S&H at the maximum of 5% or $20
		double sh = Math.max(0.05 * totalCost, 20);

		invoice.setTax(tax);
		totalCost += tax;
		invoice.setShippingAndHandling(sh);
		totalCost += sh;
		invoice.setTotalCost(totalCost);

		return invoice;
	}
}
