package com.skatestown.backend;

import java.io.PrintWriter;
import java.io.FileOutputStream;
import java.util.Date;

/**
 * Email confirmation sender
 */
public class EmailConfirmation {
    /**
     * Log file to write emails to
     */
    String logFile;
    
    /**
     * Construct a confirmation sender with a log file
     */
    public EmailConfirmation(String logFile) {
        this.logFile = logFile;
    }
    
    /**
     * Send an email confirmation
     *
     * <p>For the purposes of the book, this operation will append
     * a message to the provided log file.</p>
     *
     * @param email Email address
     * @param sku Item SKU
     * @param quantity Desired item quantity
     * @param isAvailable Result of inventory check
     * @exception Exception Most likely, an I/O error
     */
    public void send(
        String email, String sku, int quantity, boolean isAvailable)
        throws Exception
    {
        PrintWriter out = new PrintWriter(new FileOutputStream(logFile, true));
        out.println("Sending confirmation email to " + email + ": On " +
                    new Date() + " we " + 
                    (isAvailable ? "have " : "do not have ") +
                    String.valueOf(quantity) + " units of item " + sku +
                    " available.");
        out.close();
    }
}
