package ch8.ex1;

import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.ServiceClient;
import org.apache.axis.encoding.SOAPTypeMappingRegistry;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;

import java.io.InputStream;
import java.io.StringWriter;

/**
 * Purchase order submission client
 */
public class POSubmissionClient {
    /**
     * Target service URL
     */
    String url;

    /**
     * Any tracking number we get back in a SOAP header
     */
    Integer trackingNumber = null;
    
    /**
     * Create a client with a target URL
     */
    public POSubmissionClient(String url) {
        this.url = url;
    }
    
    /**
     * Invoke the PO submission web service
     *
     * @param po Purchase order document
     * @return Invoice document
     * @exception Exception I/O error or Axis error
     */
    public String invoke(InputStream po) throws Exception {
        trackingNumber = null;

        // Send the message
        ServiceClient client = new ServiceClient(url);
        client.setRequestMessage(new Message(po, true));
        client.getMessageContext().setTargetService("http://www.skatestown.com/ns/po");
        client.invoke();
        
        // Retrieve the response body
        MessageContext ctx = client.getMessageContext();
        Message outMsg = ctx.getResponseMessage();
        SOAPEnvelope envelope = outMsg.getAsSOAPEnvelope();

        SOAPHeader trackingHeader = envelope.getHeaderByName("http://BWS-ShipIt.com/", "TrackingNumber");
        if (trackingHeader != null) {
            trackingNumber = (Integer)trackingHeader.getValueAsType(SOAPTypeMappingRegistry.XSD_INT);
        }

        SOAPBodyElement body = envelope.getFirstBody();
        
        // Get the XML from the body
        StringWriter w = new StringWriter();
        SerializationContext sc = new SerializationContext(w, ctx);
        body.output(sc);
        return w.toString();
    }

    public boolean gotTrackingNumber() { return (trackingNumber != null); }

    public int getTrackingNumber() {
        if (trackingNumber != null) {
            return trackingNumber.intValue();
        }
        return -1;
    }
}
