package ch7.ex1.saveService;

import com.ibm.uddi.*; 
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;

import java.util.Vector;

import com.ibm.uddi.datatype.OverviewDoc;
import com.ibm.uddi.util.CategoryBag;
import com.ibm.uddi.datatype.binding.*;
import com.ibm.uddi.util.KeyedReference;
import com.ibm.uddi.datatype.tmodel.TModel;
import com.ibm.uddi.datatype.service.BusinessService;

import ch7.UDDIExamples;
import ch7.Util;

/**
 * Save the example businessService entry:
 * MakeCircles RFQ (based on e-Torus' tModel).
 */

public class SaveServiceMakeCirclesRFQ extends UDDIExamples{

public static void main (String args[]) {
   try {
      //set up the UDDIProxy
       setSecurity();

      UDDIProxy proxy = new UDDIProxy();
      proxy.setInquiryURL(inquiryAPI);
      proxy.setPublishURL(publishAPI);

      // Get an authorization token
      System.out.println("\nGet authtoken");
      AuthToken token = proxy.get_authToken(userid, password );
      String authToken = token.getAuthInfoString();
      System.out.println("Returned authToken:" + token.getAuthInfoString());

      //set up a businessService linked to the WeMakeIt Inc. businessEntity
      BusinessService bs = new BusinessService();
      bs.setBusinessKey(Util.getBusinessKey("Make Circles Inc."));
      bs.setName("MakeCircle's RFQ Web service");
      bs.setDefaultDescriptionString("This service is based on the RFQ service interface definition...");
   
         //the bindingTemplate indicates HTTP access to the RFQ soap service URL
         BindingTemplate bt = new BindingTemplate();
         bt.setDefaultDescriptionString("See the RFQ service interface standard. " +
                    "Use the address in the svc impl. definition if the accessPoint URL doesn't work.");
         bt.setAccessPoint(new AccessPoint("http://www.makecircles.com/services/RFQ", "http"));

            //tModel references e-Taurus' service interface definition tModel for RFQ
            //overviewDoc of instanceDetails points to the RFQ Service Implementation Definition WSDL
            TModelInstanceDetails tmid = new TModelInstanceDetails();
   
               TModelInstanceInfo tmii = new TModelInstanceInfo();
               tmii.setDefaultDescriptionString("Points to MakeCircles Inc.'s service implementation WSDL...");
               tmii.setTModelKey(Util.getTModelKey("E-Torus order RFQ Service Interface Definition"));
   
                  InstanceDetails id = new InstanceDetails();

                     OverviewDoc od = new OverviewDoc();
                     od.setOverviewURL("http://www.makecircles.com/services/order.wsdl#RFQPort");
                  id.setOverviewDoc(od);

               tmii.setInstanceDetails(id);

            tmid.getTModelInstanceInfoVector().addElement(tmii);

         bt.setTModelInstanceDetails(tmid);
         BindingTemplates bts = new BindingTemplates();
         Vector btsv = new Vector();
         btsv.addElement(bt);
         bts.setBindingTemplateVector(btsv);

      bs.setBindingTemplates(bts);

      //save the businessService
      Vector v = new Vector();
      v.addElement(bs);
      ServiceDetail sd = proxy.save_service(token.getAuthInfoString(), v);

      //print the response
      Util.printElement(sd);

   // Handle possible errors
   }catch (UDDIException e) {
      DispositionReport dr = e.getDispositionReport();
      if (dr!=null) {
         System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                        "\n operator:" + dr.getOperator() +
                        "\n generic:"  + dr.getGeneric() +
                        "\n errno:"    + dr.getErrno() +
                        "\n errCode:"  + dr.getErrCode() +
                        "\n errInfoText:" + dr.getErrInfoText());
      }
      e.printStackTrace();

   // Catch any other exception that may occur
   } catch (Exception e) {
      e.printStackTrace();
   }
}                     
}
