package ch6.ex1;
import org.apache.axis.MessageContext;
import bws.BookUtil;
import com.skatestown.data.Product;
import com.skatestown.backend.ProductDB;

/**
 * PriceCheck Web service, based on Inventory Web Service
 * Created by implementing a PriceCheckSOAPBindingImpl
 */
public class PriceCheckSOAPBindingImpl implements PriceCheckPortTypeAxis, PriceCheckPortType {
   /**
    * Checks price and quantity available given a product SKU
    *
    * @param msgContext    This is the Axis message processing context
    *                      BookUtil needs this to extract deployment
    *                      information to load the product database.
    * @param sku           product SKU
    * @return              A structure indicating price and quantity for the sku
    * @exception Exception most likely a problem accessing the DB
    */
    public AvailabilityType checkPrice (MessageContext msgContext,String sku) throws java.rmi.RemoteException{
      ProductDB db = null;
      try{
         db = BookUtil.getProductDB(msgContext);
      }catch (Exception e){
         throw new java.rmi.RemoteException(e.getMessage());
      }
      Product prod = db.getBySKU(sku);
      if(prod == null){
         throw new java.rmi.RemoteException("Product sku: " + sku + " not found.");
      }
      
      AvailabilityType at = new AvailabilityType();
      at.setSku(sku);
      at.setQuantityAvailable(prod.getNumInStock());
      at.setPrice(prod.getUnitPrice());
      return at;
   }
    public AvailabilityType checkPrice (String sku) throws java.rmi.RemoteException{
       throw new java.rmi.RemoteException("Need to generate WSDL with -messageContext option!");
    }
}
