package com.skatestown.services;

import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
//import javax.servlet.*;
//import javax.servlet.http.*;
import bws.BookUtil;
import com.skatestown.data.Product;
import com.skatestown.backend.ProductDB;

/**
 * Inventory check Web service
 */
public class InventoryCheck {
	/**
	 * Checks inventory availability given a product SKU and
	 * a desired product quantity.
	 *
	 * @param msgContext    This is the Axis message processing context
	 *                      BookUtil needs this to extract deployment
	 *                      information to load the product database.
	 * @param sku           product SKU
	 * @param quantity      quantity desired
	 * @return              true|false based on product availability
	 * @exception Exception most likely a problem accessing the DB
	 */
	public static boolean doCheck(MessageContext msgContext,
								  String sku, int quantity)
	throws Exception
	{
		ProductDB db = BookUtil.getProductDB(msgContext);
		Product prod = db.getBySKU(sku);
		return (prod != null && prod.getNumInStock() >= quantity);
	}
}
