package ch7;

import java.util.Enumeration;
import java.util.Vector;

import com.ibm.uddi.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;

/**
 * Chapter 7 - UDDI examples
 *
 * Subclasses of this class are running code related to
 * examples in the text.  These examples use UDDI4J.
 *
 * All the examples assume:
 * - A UDDI registry is running and accessible from the URLs
 *   contained in the static variables inquryAPI and publishAPI
 *
 * - The userid and password combination contained in the static
 *   variables has been registered with that private UDDI registry.
 */

public class UDDIExamples {
   //the following userid/password pair are default install parameters to the IBM WSTK private UDDI registry
   protected static String userid = "wstkDemo";
   protected static String password = "wstkPwd";

   // Select the target UDDI registry by uncommenting a pair of
   // static variable declarations.

   // The IBM UDDI test registry
   // protected static String inquiryAPI = "http://www-3.ibm.com/services/uddi/testregistry/inquiryapi";
   // protected static String inquiryAPI = "https://www-3.ibm.com/services/uddi/testregistry/protect/publishapi";

   // The IBM UDDI Business Registry operator node
   // protected static String inquiryAPI = "http://www-3.ibm.com/services/uddi/inquiryapi";
   // protected static String inquiryAPI = "https://www-3.ibm.com/services/uddi/protect/publishapi";

   // The Microsoft UDDI test registry
   // protected static String inquiryAPI = "http://test.uddi.microsoft.com/inquire";
   // protected static String inquiryAPI = "https://test.uddi.microsoft.com/publish";

   // The Microsoft UDDI Business Registry operator node
   // protected static String inquiryAPI = "http://uddi.microsoft.com/inquire";
   // protected static String inquiryAPI = "https://uddi.microsoft.com/publish";

   // The following values for a locally installed private UDDI registry from the IBM WSTK.
   protected static String inquiryAPI = "http://localhost:8080/services/uddi/servlet/uddi";
   protected static String publishAPI = "http://localhost:8080/services/uddi/servlet/uddi";
/**
 * Set the security property
 */
protected static void setSecurity() {
   // Comment out the following lines to disable SSL and HTTPS support
   // or if using a different SSL provider.
   // JSSE must be in the classpath to use or compile these lines.

   System.setProperty("java.protocol.handler.pkgs",
                  "com.sun.net.ssl.internal.www.protocol");
   java.security.Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
}
}