package ch6.ex1;
import java.text.NumberFormat;

public class PriceCheckTest {
   public static void main(String[] args){
      if(args.length != 1){
         System.err.println("Usage: PriceCheckTest sku");
         System.exit(1);
      }
      try{
         PriceCheckService pcs = new PriceCheckService();
         PriceCheckPortType pcpt = pcs.getPriceCheck();
         AvailabilityType at = pcpt.checkPrice(args[0]);
         NumberFormat df = NumberFormat.getCurrencyInstance();

         System.out.println("One " + args[0] + " costs: " + df.format(at.getPrice()) + ".");
         System.out.println("There are " + at.getQuantityAvailable() + " available.");
      }catch (Exception e){
         System.err.println("Something wrong with the PriceCheck request");
         e.printStackTrace();
      }
   }
}
