package com.skatestown.services;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.apache.axis.MessageContext;
import org.apache.axis.Message;
import org.apache.axis.AxisFault;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.client.ServiceClient;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import com.skatestown.data.PO;
import com.skatestown.data.Invoice;
import com.skatestown.backend.ProductDB;
import com.skatestown.backend.POProcessor;
import com.skatestown.xml.Serializer;
import com.skatestown.xml.Deserializer;
import bws.BookUtil;

/**
 * Purchase order submission service
 */
public class TrackingSubmission {
    /**
     * Submit a purchase order and generate an invoice
     */
    public Document doSubmission(MessageContext msgContext, Document inDoc)
        throws Exception
    {
        // Create a PO from the XML document
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        PO po = Deserializer.createPO(inDoc.getDocumentElement());
        
        // Get the product database
        ProductDB db = BookUtil.getProductDB(msgContext);
        
        // Create an invoice from the PO
        POProcessor processor = new POProcessor(db);
        Invoice invoice = processor.processPO(po);
        
        // Serialize the invoice to XML
        Document newDoc = Serializer.writeInvoice(builder, invoice);

        // Now let's go get a tracking number...
        String serviceURL = "http://localhost/ShipIt/PackageService.asmx";
        String trackingNS = "http://BWS-ShipIt.com/";

        ServiceClient client = new ServiceClient(serviceURL);
        Integer trackingNumber = (Integer)client.invoke(trackingNS,
                                    "getTrackingNumber", new Object[]{});

        Message msg = msgContext.getResponseMessage();
        if (msg == null)
            throw new AxisFault("No Response Message!!!");

        SOAPEnvelope env = msg.getAsSOAPEnvelope();

        Element el = newDoc.createElementNS(trackingNS, "TrackingNumber");
        Text textNode = newDoc.createTextNode(trackingNumber.toString());
        el.appendChild(textNode);

        SOAPHeader trackingHeader = new SOAPHeader(el);
        env.addHeader(trackingHeader);

        return newDoc;
    }
}
