package com.skatestown.services;

import bws.BookUtil;
import java.io.FileReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import com.skatestown.data.PO;
import com.skatestown.data.Invoice;
import com.skatestown.backend.ProductDB;
import com.skatestown.backend.POProcessor;
import com.skatestown.xml.Serializer;
import com.skatestown.xml.Deserializer;
import org.apache.axis.MessageContext;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/**
 * Purchase order submission service
 */
public class POSubmission2 {
    public static String PRODUCT_DB_PROPERTY="POSubmission2.ProductDB";
    /**
     * Submit a purchase order and generate an invoice
     */
    public Document doSubmission(MessageContext msgContext, Document inDoc)
        throws Exception
    {
        // Create a PO from the XML document
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();

        PO po = Deserializer.createPO(inDoc.getDocumentElement());        
        // Get the product database
        ProductDB db;
        String fname = System.getProperty(PRODUCT_DB_PROPERTY);
        if(fname!=null) {  
            factory.setNamespaceAware(true);
            InputSource input =
                new InputSource(new FileReader(fname));
            Document doc = factory.newDocumentBuilder().parse(input);

            db = new ProductDB(doc);
        } else {
            db = BookUtil.getProductDB(msgContext);
        }
        
        // Create an invoice from the PO
        POProcessor processor = new POProcessor(db);
        Invoice invoice = processor.processPO(po);
        
        // Serialize the invoice to XML
        Document newDoc = Serializer.writeInvoice(builder, invoice);
        
        return newDoc;
    }
}
