package com.skatestown.services;

import org.w3c.dom.Document;
import org.apache.axis.MessageContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import com.skatestown.data.PO;
import com.skatestown.data.Invoice;
import com.skatestown.backend.ProductDB;
import com.skatestown.backend.POProcessor;
import com.skatestown.xml.Serializer;
import com.skatestown.xml.Deserializer;
import bws.BookUtil;

/**
 * Purchase order submission service
 */
public class POSubmission {
    /**
     * Submit a purchase order and generate an invoice
     */
    public Document doSubmission(MessageContext msgContext, Document inDoc)
        throws Exception
    {
        // Create a PO from the XML document
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        PO po = Deserializer.createPO(inDoc.getDocumentElement());
        
        // Get the product database
        ProductDB db = BookUtil.getProductDB(msgContext);
        
        // Create an invoice from the PO
        POProcessor processor = new POProcessor(db);
        Invoice invoice = processor.processPO(po);
        
        // Serialize the invoice to XML
        Document newDoc = Serializer.writeInvoice(builder, invoice);
        
        return newDoc;
    }
}
