package com.skatestown.services;

import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.encoding.SOAPTypeMappingRegistry;
import bws.BookUtil;
import com.skatestown.backend.EmailConfirmation;

/**
 * EMail header handler
 */
public class EMailHandler extends BasicHandler {
    /**
     * Utility method to retrieve RPC parameters
     * from a SOAP message.
     */
    private Object getParam(Vector params, int index) {
        return ((RPCParam)params.get(index)).getValue();
    }
 
    /**
     * Looks for the EMail header and sends an email
     * confirmation message based on the inventory check
     * request and the result of the inventory check
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            // Attempt to retrieve EMail header
            Message reqMsg = msgContext.getRequestMessage();
            SOAPEnvelope reqEnv = reqMsg.getAsSOAPEnvelope();
            SOAPHeader header = reqEnv.getHeaderByName("http://www.skatestown.com/", "EMail");
 
            if (header != null) {
                // Mark the header as having been processed
                header.setProcessed(true);
 
                // Get email address in header
                String email = (String)header.getValueAsType(SOAPTypeMappingRegistry.XSD_STRING);
 
                // Retrieve request parameters: SKU & quantity
                RPCElement reqRPC = (RPCElement)reqEnv.getFirstBody();
                Vector params = reqRPC.getParams();
                String sku = (String)getParam(params, 0);
                Integer quantity = (Integer)getParam(params, 1);
 
                // Retrieve inventory check result
                Message respMsg = msgContext.getResponseMessage();
                SOAPEnvelope respEnv = respMsg.getAsSOAPEnvelope();
                RPCElement respRPC = (RPCElement)respEnv.getFirstBody();
                Boolean result = (Boolean)getParam(respRPC.getParams(), 0);
 
                // Send confirmation email
                String log = BookUtil.getResourcePath(msgContext, "/resources/email.log");
                EmailConfirmation ec = new EmailConfirmation(log);
                ec.send(email, sku, quantity.intValue(), result.booleanValue());
            }
        } catch(Exception e) {
            throw new AxisFault(e);
        }
    }
 
    /**
     * Required method of handlers. No-op in this case
     */
    public void undo(MessageContext msgContext) { }
}


