package bws;

import java.io.Reader;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.w3c.dom.Document;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import com.skatestown.backend.ProductDB;

public class BookUtil {
    static final String SITE_URL_PROPERTY_NAME = "bws.siteUrl";
    static final String DEFAULT_SITE_URL = "http://localhost:8080/bws/";
    static final String AXIS_RELATIVE_URL = "services/";
    
    public static String getSiteUrl() {
        return System.getProperty(SITE_URL_PROPERTY_NAME, DEFAULT_SITE_URL);
    }

    public static String getServiceUrl() {
        return getSiteUrl() + AXIS_RELATIVE_URL;
    }

    public static String getServiceUrl(String localPart) {
        return getServiceUrl() + localPart;
    }

    public static ServletContext getContext(MessageContext ctx) {
        HttpServlet servlet =
            (HttpServlet)ctx.getProperty(HTTPConstants.MC_HTTP_SERVLET);
        return servlet.getServletConfig().getServletContext();
    }
    
    public static String getResourcePath(ServletContext ctx, String path) {
        return ctx.getRealPath(path);
    }

    public static String getResourcePath(MessageContext ctx, String path) {
        return getResourcePath(getContext(ctx), path);
    }

    public static InputStream getResourceInputStream(ServletContext ctx,
                                                     String path)
        throws IOException
    {
        return new BufferedInputStream(new FileInputStream(getResourcePath(ctx, path)));
    }

    public static InputStream getResourceInputStream(MessageContext ctx,
                                                     String path)
        throws IOException
    {
        return getResourceInputStream(getContext(ctx), path);
    }
    
    public static Reader getResourceReader(ServletContext ctx, String path)
        throws IOException
    {
        return new BufferedReader(new FileReader(getResourcePath(ctx, path)));
    }

    public static Reader getResourceReader(MessageContext ctx, String path)
        throws IOException
    {
        return getResourceReader(getContext(ctx), path);
    }

    public static Document getResourceXML(ServletContext ctx, String path)
        throws Exception
    {
        InputStream in = getResourceInputStream(ctx, path);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        in.close();
        return doc;
    }

    public static Document getResourceXML(MessageContext ctx, String path)
        throws Exception
    {
        return getResourceXML(getContext(ctx), path);
    }

    public static Document getXML(String realPath) throws Exception {
        InputStream in = new BufferedInputStream(new FileInputStream(realPath));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        in.close();
        return doc;
    }

    public static String readResource(ServletContext ctx, String path)
        throws IOException
    {
        Reader rin = getResourceReader(ctx, path);
        return readFile(rin);
    }

    public static String readResource(MessageContext ctx, String path)
        throws IOException
    {
        Reader rin = getResourceReader(ctx, path);
        return readFile(rin);
    }

    public static String readFile(Reader rin) throws IOException {
        char[] buf = new char[2048];
        StringBuffer sb = new StringBuffer();
        int len = -1;
        while ((len = rin.read(buf)) != -1) sb.append(buf, 0, len);
        rin.close();
        return sb.toString();
    }
    
    public static ProductDB getProductDB(ServletContext ctx)
        throws Exception
    {
        Document productXML = getResourceXML(ctx, "/resources/products.xml");
        return new ProductDB(productXML);
    }

    public static ProductDB getProductDB(MessageContext ctx)
        throws Exception
    {
        return getProductDB(getContext(ctx));
    }
}
