package ch7.ex1.saveTModel;

import java.util.Vector;

import com.ibm.uddi.*; 
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;
import com.ibm.uddi.util.KeyedReference;
import com.ibm.uddi.datatype.OverviewDoc;
import com.ibm.uddi.datatype.tmodel.TModel;
import com.ibm.uddi.util.CategoryBag;

import ch7.UDDIExamples;
import ch7.Util;

/**
 * Save the example tModel entry for the
 * e-Torus order Suite POSubmission service interface definition.
 */
public class SaveTModelETorusPOSubmissionSID extends UDDIExamples{

public static void main (String args[]) {
   try {
      //set up the UDDIProxy
      setSecurity();

      UDDIProxy proxy = new UDDIProxy();
      proxy.setInquiryURL(inquiryAPI);
      proxy.setPublishURL(publishAPI);

      // Get an authorization token
      System.out.println("\nGet authtoken");
      AuthToken token = proxy.get_authToken(userid, password );
      String authToken = token.getAuthInfoString();
      System.out.println("Returned authToken:" + token.getAuthInfoString());

      //create the tModel entry
      TModel tm = new TModel();
      tm.setName("e-Torus order PO Submission Service Interface Definition");
      tm.setDefaultDescriptionString("This tModel defines the service interface definition for POSubmission within the e-Torus order suite of services.");

      //point the tModel to the WSDL spec, fragment id for the PO over SOAP binding
      OverviewDoc od = new OverviewDoc();
      od.setOverviewURL("http://www.etorus.com/services/interfaces/orderInterfaces.wsdl#POSOAPBinding");
      tm.setOverviewDoc(od);

      //categorize this tModel as a WSDL spec.
      CategoryBag cb = new CategoryBag();
      Vector keyedRefs = new Vector();
      KeyedReference kr = new KeyedReference("uddi-org:types", "wsdlSpec");
      kr.setTModelKey("uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4");      //uddi-orgs types tModel
      keyedRefs.addElement(kr);
      cb.setKeyedReferenceVector(keyedRefs);
      tm.setCategoryBag(cb);

      //save the tModel
      Vector v = new Vector();
      v.addElement(tm);
      TModelDetail tmd = proxy.save_tModel(token.getAuthInfoString(), v);
   
      //print it
      Util.printElement(tmd);

   // Handle possible errors
   }catch (UDDIException e) {
      DispositionReport dr = e.getDispositionReport();
      if (dr!=null) {
         System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                        "\n operator:" + dr.getOperator() +
                        "\n generic:"  + dr.getGeneric() +
                        "\n errno:"    + dr.getErrno() +
                        "\n errCode:"  + dr.getErrCode() +
                        "\n errInfoText:" + dr.getErrInfoText());
      }
      e.printStackTrace();

   // Catch any other exception that may occur
   } catch (Exception e) {
      e.printStackTrace();
   }
}
}
