package ch7.ex1.saveService;

import com.ibm.uddi.*;
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;

import java.util.Vector;
import java.util.Enumeration;

import com.ibm.uddi.datatype.OverviewDoc;
import com.ibm.uddi.util.CategoryBag;
import com.ibm.uddi.datatype.binding.*;
import com.ibm.uddi.util.TModelBag;
import com.ibm.uddi.util.KeyedReference;
import com.ibm.uddi.datatype.tmodel.TModel;
import com.ibm.uddi.datatype.service.BusinessService;

import ch7.UDDIExamples;
import ch7.Util;

/**
 * Update the example businessService entry:
 * WeMakeIt Inc's first priceCheck was based on SkatesTown's tModel.
 * This service is now updated as e-Torus' orderSuite tModel supercedes
 * the standard definition for SkatesTown's tModel.
 * Update WeMakeIt Inc's service to point to the e-Torus tModel.
 */

public class SaveServiceWeMakeItPriceCheckUpdate extends UDDIExamples{

public static void main (String args[]) {
   try {
      //set up the UDDIProxy
      setSecurity();

      UDDIProxy proxy = new UDDIProxy();
      proxy.setInquiryURL(inquiryAPI);
      proxy.setPublishURL(publishAPI);

      // Get an authorization token
      System.out.println("\nGet authtoken");
      AuthToken token = proxy.get_authToken(userid, password );
      String authToken = token.getAuthInfoString();
      System.out.println("Returned authToken:" + token.getAuthInfoString());

      String priceCheckTModelKeySkatesTown = 
         Util.getTModelKey("SkatesTown PriceCheck Service Interface Definition");
      String priceCheckTModelKeyETaurus = 
         Util.getTModelKey("e-Torus order suite PriceCheck Service Interface Definition");

      String bk = Util.getBusinessKey("WeMakeIt Inc.");
      String serviceName = "WeMakeIt Inc.'s Price Check Service";

      ServiceList sl = proxy.find_service(bk, serviceName, null, 0);
      ServiceInfos sis = sl.getServiceInfos();
      Vector siv = sis.getServiceInfoVector();
      ServiceInfo si = (ServiceInfo)siv.firstElement();

      //find all the bindings for the SkatesTown tModel
      TModelBag bag = new TModelBag();
      Vector v = new Vector();
      v.addElement(priceCheckTModelKeySkatesTown);
      bag.setTModelKeyStrings(v);

      BindingDetail bd = proxy.find_binding(null, si.getServiceKey(), bag, 0);
      Vector bdv = bd.getBindingTemplateVector();
      Enumeration e = bdv.elements();
      while(e.hasMoreElements()){
         BindingTemplate bt = (BindingTemplate)e.nextElement();
         TModelInstanceDetails tmids = bt.getTModelInstanceDetails();
         Vector tmidv = tmids.getTModelInstanceInfoVector();
         Enumeration e2 = tmidv.elements();
         while(e2.hasMoreElements()){
            TModelInstanceInfo tmii = (TModelInstanceInfo)e2.nextElement();
            if(tmii.getTModelKey().equals(priceCheckTModelKeySkatesTown)){
               tmii.setTModelKey(priceCheckTModelKeyETaurus);
               Vector save = new Vector();
               save.addElement(bt);
               //hack to get around description save bug
               bt.setDescriptionVector(new Vector());
               bt.setDefaultDescriptionString("Updated service to point to e-Torus priceCheck tModel");
               BindingDetail updatedbd = proxy.save_binding(authToken, save);
               System.out.println("Updated service");
               Util.printElement(updatedbd);
            }
         }
      }

   // Handle possible errors
   }catch (UDDIException e) {
      DispositionReport dr = e.getDispositionReport();
      if (dr!=null) {
         System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                        "\n operator:" + dr.getOperator() +
                        "\n generic:"  + dr.getGeneric() +
                        "\n errno:"    + dr.getErrno() +
                        "\n errCode:"  + dr.getErrCode() +
                        "\n errInfoText:" + dr.getErrInfoText());
      }
      e.printStackTrace();

   // Catch any other exception that may occur
   } catch (Exception e) {
      e.printStackTrace();
   }
}                     
}
