package ch7;

import java.io.StringWriter; 
import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import org.apache.xml.serialize.XMLSerializer;
import org.apache.xml.serialize.OutputFormat;

import com.ibm.uddi.UDDIElement;
import com.ibm.uddi.UDDIException;
import com.ibm.uddi.client.UDDIProxy;
import com.ibm.uddi.datatype.tmodel.TModel;
import com.ibm.uddi.response.DispositionReport;
import com.ibm.uddi.response.TModelList;
import com.ibm.uddi.response.TModelInfo;
import com.ibm.uddi.response.BusinessList;
import com.ibm.uddi.response.BusinessInfo;

/**
 * Chapter 7 - UDDI examples
 *
 * Utility class for convenience printing and
 * convenience find by name.
 */

public class Util extends UDDIExamples{

/**
 * Return the businessKey for a business with given name
 * @return String
 * @param name java.lang.String
 */
public static String getBusinessKey(String name) {
   try {
      //set up the UDDIProxy
      setSecurity();

      UDDIProxy proxy = new UDDIProxy();
      proxy.setInquiryURL(inquiryAPI);
      proxy.setPublishURL(publishAPI);

      //find business with given name
      BusinessList bl = proxy.find_business(name, null, 1);

      //return the key of the first element
      Vector businessInfoVector  = bl.getBusinessInfos().getBusinessInfoVector();
      BusinessInfo businessInfo = (BusinessInfo)businessInfoVector.elementAt(0);
   
      return businessInfo.getBusinessKey();
   // Handle possible errors
   }catch (UDDIException e) {
      DispositionReport dr = e.getDispositionReport();
      if (dr!=null) {
         System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                        "\n operator:" + dr.getOperator() +
                        "\n generic:"  + dr.getGeneric() +
                        "\n errno:"    + dr.getErrno() +
                        "\n errCode:"  + dr.getErrCode() +
                        "\n errInfoText:" + dr.getErrInfoText());
      }
      e.printStackTrace();

   // Catch any other exception that may occur
   } catch (Exception e) {
      e.printStackTrace();
   }
   return null;   //return null if error
}

/**
 * Return the tModelKey for a tModel with given name
 * @return String
 * @param name java.lang.String
 */
public static String getTModelKey(String name) {
   try {
      //set up the UDDIProxy
      setSecurity();

      UDDIProxy proxy = new UDDIProxy();
      proxy.setInquiryURL(inquiryAPI);
      proxy.setPublishURL(publishAPI);

      //find the tModel with the given name
      TModelList tml = proxy.find_tModel(name, null, 1);

      //return the key of the first element
      Vector victor = tml.getTModelInfos().getTModelInfoVector();
      TModelInfo tm = (TModelInfo)victor.elementAt(0);
      return tm.getTModelKey();

   // Handle possible errors
   }catch (UDDIException e) {
      DispositionReport dr = e.getDispositionReport();
      if (dr!=null) {
         System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                        "\n operator:" + dr.getOperator() +
                        "\n generic:"  + dr.getGeneric() +
                        "\n errno:"    + dr.getErrno() +
                        "\n errCode:"  + dr.getErrCode() +
                        "\n errInfoText:" + dr.getErrInfoText());
      }
      e.printStackTrace();


   // Catch any other exception that may occur
   } catch (Exception e) {
      e.printStackTrace();
   }
   return null;   //return null if error
}

/**
 * Print the given Dom element to the system console
 * @param Element org.w3c.dom.Element
 */
public static void printElement(UDDIElement uddiElement) {
   Element base = null;
   Document doc = null;
   try {
      DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
      base = docBuilder.newDocument().createElement("Ch7Ex");
      uddiElement.saveToXML(base);
      printElement(base);
   }catch (Exception e){
      e.printStackTrace();
   }
}

/**
 * Print the given Dom element to the system console
 * @param Element org.w3c.dom.Element
 */
public static void printElement(Element base) {   
   try{
      OutputFormat format = new OutputFormat( base.getOwnerDocument() );   //Serialize DOM
      format.setIndent(3);
      StringWriter stringOut = new StringWriter();
      XMLSerializer serial = new XMLSerializer( stringOut, format );
      serial.asDOMSerializer();                           
      serial.serialize( base );

      System.out.println( stringOut.toString() ); //Spit out DOM as a String   
   } catch (Exception e) {
      e.printStackTrace();
   }
}
}

