package ch7.ex2;

import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import com.ibm.uddi.UDDIException;
import com.ibm.uddi.client.UDDIProxy;
import com.ibm.uddi.response.*;
import com.ibm.uddi.datatype.binding.*;
import com.ibm.uddi.datatype.service.BusinessService;
import com.ibm.uddi.datatype.binding.TModelInstanceDetails;
import com.ibm.uddi.util.TModelBag;

import ch7.UDDIExamples;
import ch7.Util;

import ch6.ex1.*;

/**
 * Chapter 7 - UDDI examples
 *
 * The final example of dynamic find.
 * SkatesTown does a find for all businesses that
 * implement PriceCheck and POSubmission.
 * Based on best priceCheck, a PO is placed with the
 * supplier with the best price.
 * 
 */
public class DynamicFindSkatesTown extends UDDIExamples{
	
/**
 * Place a PO with the supplier that has best priceCheck price.
 * Use the supplier's POSubmission service to place the PO.
 */
public static void main (String args[]) {
   try {
   	
      if(args.length != 1){
      	 System.err.println("Usage: DynamicFindSkatesTown SKU");
      	 System.exit(1);
      }
      
   	  String sku = args[0];
   	  
      //set up the UDDIProxy
      setSecurity();
      UDDIProxy proxy = new UDDIProxy();
      proxy.setInquiryURL(inquiryAPI);
      proxy.setPublishURL(publishAPI);

      String priceCheckTModelKey = 
         Util.getTModelKey("E-Torus order suite PriceCheck Service Interface Definition");
      String POSubmissionTModelKey = 
         Util.getTModelKey("E-Torus order PO Submission Service Interface Definition");
      //set up the TModelBag to refer to both the priceCheck and POSubmission
      //suppliers must support both standards in order to be invoked by the
      //application
      TModelBag bag = new TModelBag();
      Vector v = new Vector();

      //UUID of priceCheck tModel
      v.addElement(priceCheckTModelKey);
      //UUID of POSubmission tModel
      v.addElement(POSubmissionTModelKey);
      bag.setTModelKeyStrings(v);

      //finds all businesses that have a service implementing the priceCheck tModel
      BusinessList bl = proxy.find_business(bag, null, 0);
      //print it
      System.out.println("List the businesses that support priceCheck and POSubmission");
      Util.printElement(bl);
      //loop through the BusinessList, invoking the priceCheck web service
      //Find the binding that matches the TModel for priceCheck
      TModelBag bag2 = new TModelBag();
      Vector v2 = new Vector();
      //UUID of priceCheck tModel
      v2.addElement(priceCheckTModelKey);
      bag2.setTModelKeyStrings(v2);
      Vector biv = bl.getBusinessInfos().getBusinessInfoVector();
      Enumeration e = biv.elements();
      while(e.hasMoreElements()){
         BusinessInfo bi = (BusinessInfo)e.nextElement();
         ServiceInfos sis = bi.getServiceInfos();
         Vector siv = sis.getServiceInfoVector();
         Enumeration e2 = siv.elements();

         //loop through the binding templates until a bt is found
         BindingTemplate bt = null;
         while(e2.hasMoreElements() && bt == null){
            ServiceInfo si = (ServiceInfo)e2.nextElement();
            
            //find the service's bindingDetail that corresponds to the priceCheck tModel
            BindingDetail bd = proxy.find_binding(null, si.getServiceKey(), bag2,0);
            Vector btv = bd.getBindingTemplateVector();
            Enumeration e3 = btv.elements();
            
            //the tModel is hidden in the TModelInstanceDetails
            while(e3.hasMoreElements() && bt == null){
               bt = (BindingTemplate)e3.nextElement();
               Vector tmidv = bt.getTModelInstanceDetails().getTModelInstanceInfoVector();
               Enumeration e4 = tmidv.elements();

               TModelInstanceInfo tmii = null;
               while(e4.hasMoreElements() && tmii==null){
                  tmii = (TModelInstanceInfo)e4.nextElement();
                  if(! tmii.getTModelKey().equals(priceCheckTModelKey)){
                     tmii = null;//continue
                  }
               }
               if(tmii == null){
                  bt = null; //continue
               }
            }
         }
         
         //invoke the priceCheck WSDL proxy, passing access point, item
         PriceCheckService pcs = new PriceCheckService();
         PriceCheckPortType pcpt = pcs.getPriceCheck(new java.net.URL(bt.getAccessPoint().getText()));
         
         //for now, avoid the invocation as the various company's services are not set up
         //AvailabilityType at = pcpt.checkPrice(sku); //some SKU
         //double price = at.getPrice();

         //cache the price in a data structure that associates the businessKey with the price

         //instead of invoking, print
         System.out.println("Business: " + bi.getNameString() + " priceCheck service accessPoint: " + bt.getAccessPoint().getText());
      }
      
      //use the cache to determine the winning supplier's business Key based on best price
      //force the issue by choosing We Make It Inc.
      String winnerBusKey = Util.getBusinessKey("WeMakeIt Inc.");
      
      TModelBag bag3 = new TModelBag();
      v = new Vector();
      v.addElement(POSubmissionTModelKey);
      bag3.setTModelKeyStrings(v);
      ServiceList sl = proxy.find_service(winnerBusKey, bag3, null, 0);
      ServiceInfos sis = sl.getServiceInfos();
      
      //take first matching service, normally one would check for multiples and choose best
      ServiceInfo si = (ServiceInfo)sis.getServiceInfoVector().firstElement();
      ServiceDetail sd = proxy.get_serviceDetail(si.getServiceKey());
      BusinessService bs = (BusinessService)sd.getBusinessServiceVector().firstElement();

      //traverse the bindingTemplates structure looking for the binding template for
      //the POSubmission TModel
      BindingTemplate bt = null;
      Vector btv =  bs.getBindingTemplates().getBindingTemplateVector();
      Enumeration e2 = btv.elements();

      //the tModel is hidden in the TModelInstanceDetails
      while(e2.hasMoreElements() && bt == null){
         bt = (BindingTemplate)e2.nextElement();
         Vector tmidv = bt.getTModelInstanceDetails().getTModelInstanceInfoVector();
         Enumeration e3 = tmidv.elements();
         TModelInstanceInfo tmii = null;
         while(e3.hasMoreElements() && tmii==null){
            tmii = (TModelInstanceInfo)e3.nextElement();
            if(! tmii.getTModelKey().equals(POSubmissionTModelKey)){
               tmii = null;//continue
            }
         }
         if(tmii == null){
            bt = null; //continue
         }
      }
         
      //invoke the POSubmission WSDL proxy, passing access point, purchase Order
      System.out.println(" PO service accessPoint: " + bt.getAccessPoint().getText());

        // Handle possible errors
   } catch (UDDIException e) {
      DispositionReport dr = e.getDispositionReport();
      if (dr!=null) {
         System.out.println("UDDIException faultCode:" + e.getFaultCode() +
            "\n operator:" + dr.getOperator() +
            "\n generic:"  + dr.getGeneric() +
            "\n errno:"    + dr.getErrno() +
            "\n errCode:"  + dr.getErrCode() +
            "\n errInfoText:" + dr.getErrInfoText());
      }
      e.printStackTrace();

      // Catch any other exception that may occur
      } catch (Exception e) {
         e.printStackTrace();
      }
 
     System.exit(0);
   }                                                                                                                     
}