package ch7.ex1.saveBusiness;

import com.ibm.uddi.*;
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;

import java.util.Vector;
import java.util.Enumeration;

import com.ibm.uddi.util.*;

import ch7.UDDIExamples;
import ch7.Util;

/**
 * Save the example businessEntity entries for
 * WeMakeIt and the Asian and European subsidiaries.
 */

public class SaveBusinessWeMakeIt extends UDDIExamples{

public static void main (String args[]) {
   try {
      //set up the UDDIProxy
      setSecurity();

      UDDIProxy proxy = new UDDIProxy();
      proxy.setInquiryURL(inquiryAPI);
      proxy.setPublishURL(publishAPI);

      // Get an authorization token
      System.out.println("\nGet authtoken");
      AuthToken token = proxy.get_authToken(userid, password );
      String authToken = token.getAuthInfoString();
      System.out.println("Returned authToken:" + token.getAuthInfoString());

      System.out.println("\nSave 'WeMakeIt Inc.'");
      Vector entities = new Vector();

      // Create a new business entity using required elements constructor
      // Name is the business name. 
      // BusinessKey must be "" to save a new business
      BusinessEntity be = new BusinessEntity("", "WeMakeIt Inc.");

      //add the discovery URL to point to WeMakeIt Inc.'s private Portal UDDI
      DiscoveryURLs dus = new DiscoveryURLs();
      Vector victor = dus.getDiscoveryURLVector(); 
      DiscoveryURL du = new DiscoveryURL();
      du.setUseType("urn:uddi-inquiry-api");
      du.setText("http://www.wemakeit.com/services/uddi/servlet/uddi");
      victor.addElement(du);
      be.setDiscoveryURLs(dus);

      entities.addElement(be);

      // Create new  business entities for the two international subsidiaries
      // of WeMakeIt Inc.
      BusinessEntity be2 = new BusinessEntity("", "WeMakeIt Asia Inc.");
      entities.addElement(be2);
      BusinessEntity be3 = new BusinessEntity("", "WeMakeIt Europe Plc.");
      entities.addElement(be3);

      // Save businesses
      BusinessDetail bd = proxy.save_business(token.getAuthInfoString(),entities);

      // Process returned BusinessDetail object
      // Loop though list of businessEntity entries, print them out
      Vector businessEntities = bd.getBusinessEntityVector();

      Enumeration e = businessEntities.elements();
      while(e.hasMoreElements()){
         Util.printElement((BusinessEntity)e.nextElement());
      }

   // Handle possible errors
   }catch (UDDIException e) {
      DispositionReport dr = e.getDispositionReport();
      if (dr!=null) {
         System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                        "\n operator:" + dr.getOperator() +
                        "\n generic:"  + dr.getGeneric() +
                        "\n errno:"    + dr.getErrno() +
                        "\n errCode:"  + dr.getErrCode() +
                        "\n errInfoText:" + dr.getErrInfoText());
      }
      e.printStackTrace();

   // Catch any other exception that may occur
   } catch (Exception e) {
      e.printStackTrace();
   }
}
}