package ch7;

import java.util.*;

import com.ibm.uddi.UDDIException;
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;

/**
 * Chapter 7 - UDDI examples
 *
 * Sample code that exercises the publish API. 
 *
 * Delete all the entries created for this publisher
 * 
 * <OL>
 * <LI>Sets up a UDDIProxy object
 * <LI>Requests an authorization token
 * <LI>Deletes all entries associated with the auth. token
 * <LI>Prints messages only if delete fails
 * </OL>
 */

public class DeleteAll extends UDDIExamples {
/**
 * Delete all the UDDI entries associated with the value in the
 * userid field
 */
public static void main(String args[]){
   try {
      //set up the UDDIProxy
      setSecurity();

      UDDIProxy proxy = new UDDIProxy();
      proxy.setInquiryURL(inquiryAPI);
      proxy.setPublishURL(publishAPI);

      //retrieve all the records owned by the publisher
      AuthToken token = proxy.get_authToken(userid, password );
      String authToken = token.getAuthInfoString();
      RegisteredInfo ri = proxy.get_registeredInfo(authToken);

      Vector v;
      Enumeration e;

      //delete all the businessEntities and child elements
      BusinessInfos bis = ri.getBusinessInfos();
      v = bis.getBusinessInfoVector();
      e = v.elements();
      while(e.hasMoreElements()){
         BusinessInfo bi = (BusinessInfo)e.nextElement();
         DispositionReport dr = proxy.delete_business(authToken, bi.getBusinessKey());
         if(!dr.success()){
            System.err.println("Deleting business: " + bi.getBusinessKey() + " failed.");
            Util.printElement(dr);
         }
      }

      //delete all the tModels
      TModelInfos tmis = ri.getTModelInfos();
      v = tmis.getTModelInfoVector();
      e = v.elements();
      while(e.hasMoreElements()){
         TModelInfo tmi = (TModelInfo)e.nextElement();
         DispositionReport dr = proxy.delete_tModel(authToken, tmi.getTModelKey());
         if(!dr.success()){
            System.err.println("Deleting tModel: " + tmi.getTModelKey() + " failed.");
            Util.printElement(dr);
         }
      }

   }catch (UDDIException e) {
      DispositionReport dr = e.getDispositionReport();
      if (dr!=null) {
         System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                        "\n operator:" + dr.getOperator() +
                        "\n generic:"  + dr.getGeneric() +
                        "\n errno:"    + dr.getErrno() +
                        "\n errCode:"  + dr.getErrCode() +
                        "\n errInfoText:" + dr.getErrInfoText());
      }
      e.printStackTrace();

   // Catch any other exception that may occur
   } catch (Exception e) {
      e.printStackTrace();
   }
}                                                            
}

