var TextUtil = new Object;

TextUtil.isNotMax = function(oTextArea) {
    return oTextArea.value.length != oTextArea.getAttribute("maxlength");
};

TextUtil.blockChars = function (oTextbox, oEvent, bBlockPaste) {

    oEvent = EventUtil.formatEvent(oEvent);
         
    var sInvalidChars = oTextbox.getAttribute("invalidchars");
    var sChar = String.fromCharCode(oEvent.charCode);
    
    var bIsValidChar = sInvalidChars.indexOf(sChar) == -1;
       
    if (bBlockPaste) {
        return bIsValidChar && !(oEvent.ctrlKey && sChar == "v");
    } else {
        return bIsValidChar || oEvent.ctrlKey;
    }
};

TextUtil.allowChars = function (oTextbox, oEvent, bBlockPaste) {

    oEvent = EventUtil.formatEvent(oEvent);
         
    var sValidChars = oTextbox.getAttribute("validchars");
    var sChar = String.fromCharCode(oEvent.charCode);
    
    var bIsValidChar = sValidChars.indexOf(sChar) > -1;
    
    if (bBlockPaste) {
        return bIsValidChar && !(oEvent.ctrlKey && sChar == "v");
    } else {
        return bIsValidChar || oEvent.ctrlKey;
    }
};

TextUtil.blurBlock = function(oTextbox) {

    // pobranie zbioru niedozwolonych znakw
    var sInvalidChars = oTextbox.getAttribute("invalidchars");

    // wczytanie zbioru niedozwolonych znakw do tablicy znakw
    var aInvalidChars = sInvalidChars.split("");
    
    // iteracja poprzez znaki
    for (var i=0; i< aInvalidChars.length; i++){
        if (oTextbox.value.indexOf(aInvalidChars[i]) > -1) {
            alert("Znak '" + aInvalidChars[i] + "' nie jest dozwolony.");
            oTextbox.focus();
            oTextbox.select();
            return;
        }
    }    
};


TextUtil.blurAllow = function(oTextbox) {
    // pobranie zbioru dozwolonych znakw
    var sValidChars = oTextbox.getAttribute("validchars");
    
    // wczytanie cigu znakw stanowicego warto pola tekstowego do tablicy znakw
    var aTextChars = oTextbox.value.split("");
   
    // iteracja poprzez znaki
    for (var i=0; i< aTextChars.length; i++){
        if (sValidChars.indexOf(aTextChars[i]) == -1) {
             alert("Znak '" + aTextChars[i] + "' nie jest dozwolony.");
             oTextbox.focus();
             oTextbox.select();
             return;
        }
    }
};    

TextUtil.numericScroll = function (oTextbox, oEvent) {

    oEvent = EventUtil.formatEvent(oEvent);
    var iValue = oTextbox.value.length == 0 ? 0 :parseInt(oTextbox.value);
    
    var iMax = oTextbox.getAttribute("max");
    var iMin = oTextbox.getAttribute("min");

    if (oEvent.keyCode == 38) {
        if (iMax == null || iValue < iMax) {
            oTextbox.value = (iValue + 1);
        }
    } else if (oEvent.keyCode == 40){
        if (iMin == null || iValue > iMin) {
            oTextbox.value = (iValue - 1);
        }
    }
};

TextUtil.autosuggestMatch = function (sText, aValues) {

    var aResult = new Array;

    if (sText != "") {
        for (var i=0; i < aValues.length; i++) {
            if (aValues[i].indexOf(sText) == 0) {
                aResult.push(aValues[i]);
            }
        }
    }

   return aResult;

};

TextUtil.autosuggest = function (oTextbox, aValues, sListboxId) {
    
    var oListbox = document.getElementById(sListboxId);
    
    ListUtil.clear(oListbox);

    var aMatches = TextUtil.autosuggestMatch(oTextbox.value, aValues);
    
    
    
    for (var i=0; i < aMatches.length; i++) {
        ListUtil.add(oListbox, aMatches[i]);
    }
    
};
