<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:template match="/">
<div>
<p align="center" class="12ptBold"><xsl:value-of select="jspbuzz/title"/></p>
    <xsl:if test="count(jspbuzz/buzzlink[@type='news']) > 0">
           <div class="10ptBold">Nowo&#347;ci</div>
           <ol><xsl:apply-templates select="jspbuzz/buzzlink[@type='news']">
                           <xsl:sort data-type="number" select="@position"/>
               </xsl:apply-templates></ol>
    </xsl:if>
    <xsl:if test="count(jspbuzz/ramble) >0">
           <div class="10ptBold">Przegl&#261;d</div>
           <ol>
           <xsl:apply-templates select="jspbuzz/ramble">
                   <xsl:sort data-type="number" select="@position"/>
           </xsl:apply-templates></ol>
    </xsl:if>
    <div class="10ptBold">Ciekawe &#322;&#261;cza</div>
    <ol><xsl:apply-templates select="jspbuzz/buzzlink[@type='link']">
                    <xsl:sort data-type="number" select="@position"/>
        </xsl:apply-templates></ol>
    <xsl:if test="count(jspbuzz/buzzlink[@type='product']) >0">
           <div class="10ptBold">Produkty</div>
           <ol><xsl:apply-templates select="jspbuzz/buzzlink[@type='product']">
                           <xsl:sort data-type="number" select="@position"/>
               </xsl:apply-templates></ol>
    </xsl:if>
    <xsl:if test="count(jspbuzz/buzzlink[@type='review']) >0">
           <div class="10ptBold">Reviews</div>
           <ol><xsl:apply-templates select="jspbuzz/buzzlink[@type='review']">
                           <xsl:sort data-type="number" select="@position"/>
                   </xsl:apply-templates></ol>
    </xsl:if>
    <xsl:if test="count(jspbuzz/topic) >0">
            <div class="10ptBold">Main Topic</div>
            <p> <a href="#topic" ><xsl:value-of select="jspbuzz/topic/title"/>
                </a></p><br/>
    </xsl:if>
</div>
</xsl:template>
<xsl:template match="jspbuzz/buzzlink">
        <li><a href="{@linksource}#{@type}{@position}">
                        <xsl:value-of select="title"/>
            </a></li>
</xsl:template>
<xsl:template match="jspbuzz/ramble">
        <li><a href="{@linksource}#ramble{@position}">
                        <xsl:value-of select="title"/>
            </a></li>
</xsl:template>
</xsl:stylesheet>
